/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.BinHelper;
import com.swimap.base.rpc.DefaultEventParser;
import com.swimap.base.rpc.EventClassTypeUtil;
import com.swimap.base.rpc.RpcEventManager;
import com.swimap.base.rpc.RpcEventSender;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.cdr.CdrEvent;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.io.ByteArrayInputStream;

public class RpcEvent {
    public static final String LOCAL_EVENT_PREFIX = "local.";
    public static final String PARA_NAME_TYPE = "_type";
    public static final String UNKNOWN_EVENT_TYPE = "UnknownEventType";
    private static DefaultEventParser parser;
    private RpcMessage message;

    public static RpcEvent create(String eventType) {
        return new RpcEvent(eventType);
    }

    private static RpcEvent createByCdrEventType(EventClassType eventType) {
        RpcEvent event = new RpcEvent();
        event.message = new RpcMessage("event");
        EventClassTypeUtil.setCdrEventClassType2RpcEventMessage(eventType, event.message);
        return event;
    }

    private RpcEvent(RpcEvent event) {
        this.message = event.message;
    }

    public RpcEvent(String type) {
        this.message = new RpcMessage("event");
        EventClassTypeUtil.setEventType(type, this.message);
    }

    protected RpcEvent() {
        this.message = new RpcMessage("event");
    }

    protected RpcEvent(byte[] byteArray) {
        ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
        this.message = BinHelper.parseMessage(input);
    }

    public RpcEvent(RpcMessage message) {
        this.message = message;
        this.message.setType("event");
    }

    public RpcMessage getMessage() {
        return this.message;
    }

    RpcEvent copy(String eventType) {
        RpcMessage rpcMessage = new RpcMessage("event");
        rpcMessage.parameterMap.putAll(this.message.getParameterMap());
        rpcMessage.parameters.addAll(this.message.parameters);
        rpcMessage.tables = this.message.tables;
        rpcMessage.extData = this.message.extData;
        EventClassTypeUtil.remove_EventType_EventClassType(rpcMessage);
        EventClassTypeUtil.setEventType(eventType, rpcMessage);
        return new RpcEvent(rpcMessage);
    }

    public String getType() {
        return EventClassTypeUtil.getEventType(this.message);
    }

    public boolean isLocal() {
        return this.getType().startsWith(LOCAL_EVENT_PREFIX);
    }

    public void setType(String type) {
        EventClassTypeUtil.setEventType(type, this.message);
    }

    public void addParameter(String name, Object value) {
        this.message.addParameter(name, value);
    }

    public void addTable(DataTable table) {
        this.message.addTable(table);
    }

    public void addAttachment(String name, byte[] data) {
        this.message.addAttachment(name, data);
    }

    public void send() {
        RpcEvent event = new RpcEvent(this);
        RpcEventSender.instance.send(event);
        this.reset();
    }

    public static void send(CdrEvent event) {
        RpcEvent e = RpcEvent.createByCdrEventType(event.getEventClassType());
        e.message.setExtData(event);
        e.send();
    }

    public boolean isCdrEvent() {
        Object extData = this.message.getExtData();
        return extData != null && extData instanceof CdrEvent;
    }

    public CdrEvent asCdrEvent() {
        if (this.isCdrEvent()) {
            return (CdrEvent)this.message.getExtData();
        }
        return null;
    }

    public void reset() {
        String eventType = EventClassTypeUtil.getEventType(this.message);
        EventClassType eventClassType = EventClassTypeUtil.getEventClassType(this.message);
        this.message = new RpcMessage("event");
        EventClassTypeUtil.setEventType(eventType, this.message);
        EventClassTypeUtil.setEventClassType(eventClassType, this.message);
    }

    public static void subscribe(String eventType, Object service, String methodName) throws Exception {
        RpcEventManager.instance().subscribeEvent(EventClassType.createByEventType(eventType), service, methodName, false);
    }

    public static void subscribe(String sourceClass, String eventType, Object service, String methodName) throws Exception {
        RpcEventManager.instance().subscribeEvent(EventClassType.createBySourceType(sourceClass, eventType), service, methodName, false);
    }

    public static void subscribe(String eventType, Object service, String methodName, boolean enableCancel) throws Exception {
        RpcEventManager.instance().subscribeEvent(EventClassType.createByEventType(eventType), service, methodName, enableCancel);
    }

    public static void subscribeSync(String eventType, Object service, String methodName) throws Exception {
        RpcEventManager.instance().subscribeSyncEvent(eventType, service, methodName);
    }

    public static void addPendingSubscribe(String eventType, Object service, String methodName, Runnable notifier) {
        RpcEventManager.instance().addPendingSubscribe(eventType, service, methodName, notifier);
    }

    public static void unsubscribe(String eventType, Object service, String methodName) throws Exception {
        RpcEventManager.instance().unsubscribeEvent(eventType, service, methodName);
    }

    public static DefaultEventParser getDefaultEventParser() {
        if (parser == null) {
            parser = new DefaultEventParser();
        }
        return parser;
    }

    public static interface IEventParser {
        public RpcEvent parse(CdrEvent var1);
    }
}

