/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.framework.dao.DataSourceManager;
import com.swimap.external.dsf.base.rpc.Base64;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.dsf.base.rpc.cdr.CdrArguments;
import com.swimap.external.dsf.base.rpc.mrb.CdrResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RpcContext {
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private long clientID;
    private int connectionID;
    private Method method;
    private String clientAddress = "Unknown";
    private String requestPath;
    private RpcMessage message;
    private RpcMessage response;
    private List<Connection> connList;

    public RpcContext(Method method, HttpServletRequest request, HttpServletResponse response, RpcMessage message) throws Exception {
        this.method = method;
        this.servletRequest = request;
        this.servletResponse = response;
        this.message = message;
    }

    public RpcContext(Method method, String path, RpcMessage message) {
        this.method = method;
        this.requestPath = path;
        this.message = message;
    }

    public RpcMessage getResponseMessage() {
        if (this.response == null) {
            this.response = new RpcMessage("response");
            if (this.message.hasMessageId()) {
                this.response.setMessageId(this.message.getMessageId());
            }
        }
        return this.response;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public String getPath() {
        if (this.servletRequest != null) {
            return this.servletRequest.getPathInfo();
        }
        return this.requestPath;
    }

    public RpcMessage getMessage() {
        return this.message;
    }

    public String getSession() {
        return this.message.getSessionId();
    }

    public byte[] getSessionBytes() {
        if (this.hasSession()) {
            return Base64.decode(this.getSession());
        }
        return null;
    }

    public boolean hasSession() {
        return this.message.hasSessionId();
    }

    public void returnResultSet(String name, ResultSet rs, String ... colNames) throws SQLException {
        DataTable table = new DataTable(name, colNames);
        DataRecord record = null;
        int col = 0;
        while (rs.next()) {
            record = new DataRecord(table);
            col = 0;
            for (int i = 0; i < colNames.length; ++i) {
                if (colNames[i] == null) continue;
                record.set(col++, rs.getObject(i + 1));
            }
            table.add(record);
        }
        this.getResponseMessage().addTable(table);
    }

    public void returnResultSet(String name, ResultSet rs) throws SQLException {
        DataTable table = new DataTable(name);
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            table.addColumn(meta.getColumnName(i).toLowerCase());
        }
        DataRecord record = null;
        while (rs.next()) {
            record = new DataRecord(table);
            for (int i = 0; i < columnCount; ++i) {
                record.set(i, rs.getObject(i + 1));
            }
            table.add(record);
        }
        this.getResponseMessage().addTable(table);
    }

    public void returnMessage(String message) {
        this.getResponseMessage().addParameter("message", message);
    }

    public void returnTable(DataTable table) {
        this.getResponseMessage().addTable(table);
    }

    public void returnParameter(String name, Object value) {
        this.getResponseMessage().addParameter(name, value);
    }

    public void returnAttachment(String name, byte[] data) {
        this.getResponseMessage().addAttachment(name, data);
    }

    public void setResponse(RpcResponse response) {
        this.response = response.getMessage();
    }

    public long getClientID() {
        return this.clientID;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public void setClientID(long clientID) {
        this.clientID = clientID;
    }

    public void setConnectionID(int connectionID) {
        this.connectionID = connectionID;
    }

    public Connection getConnection(String dsName) throws Exception {
        Connection conn;
        if (this.connList == null) {
            this.connList = new ArrayList<Connection>();
        }
        if ((conn = DataSourceManager.instance().getConnection(dsName)) != null) {
            this.connList.add(conn);
        }
        return conn;
    }

    public void close() throws Exception {
        if (this.connList != null) {
            for (Connection conn : this.connList) {
                if (conn == null) continue;
                conn.close();
            }
            this.connList.clear();
        }
    }

    public boolean hasCdrArguments() {
        return this.message != null && this.message.hasAttachment("_cdr");
    }

    public CdrArguments getCdrArguments() {
        if (this.hasCdrArguments()) {
            return new CdrArguments(this.message.getAttachment("_cdr"));
        }
        return null;
    }

    public void returnCdrResponse(CdrResponse rsp) {
        if (rsp != null) {
            this.getResponseMessage().addAttachment("_cdr", rsp.encode());
        }
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getClientAddress() {
        if (this.servletRequest != null) {
            return this.servletRequest.getRemoteAddr();
        }
        return this.clientAddress;
    }

    public <T extends Annotation> T getMethodAnnotation(Class<T> cls) {
        if (this.method != null) {
            return this.method.getAnnotation(cls);
        }
        return null;
    }

    public <T extends Annotation> T getServiceAnnotation(Class<T> cls) {
        if (this.method != null) {
            return this.method.getDeclaringClass().getAnnotation(cls);
        }
        return null;
    }

    public boolean isWebContext() {
        return this.servletRequest != null;
    }

    public void returnInternalError(int errorCode, String errorDesc) {
        this.returnParameter("com.swimap.base.rpc.internal.error.code", errorCode);
        this.returnParameter("com.swimap.base.rpc.internal.error.DESC", errorDesc);
    }
}

