/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.INATUtillityHelper;
import com.swimap.base.rpc.NATUtilityHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NATUtility {
    private static Log log = LogFactory.getLog(NATUtility.class);
    private static NATUtility instance;
    private String usage = null;
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    public static String masterIp;
    private List<String> ipMapLines = null;
    private static INATUtillityHelper helper;

    private static NATUtility getInstance() {
        if (instance == null) {
            instance = new NATUtility();
        }
        return instance;
    }

    public static String[] getNATIps(String ipAddress) {
        return NATUtility.getInstance().getNATIpsImpl(ipAddress);
    }

    public static String getValidIp(String ipAddress) {
        return NATUtility.getInstance().getValidIpImpl(ipAddress, null);
    }

    public static String getValidIp(String ipAddress, List<String> ipMapLines) {
        if (ipMapLines == null) {
            log.error((Object)"getValidIP ipMapLines is null, return null");
            return null;
        }
        String validIp = NATUtility.getInstance().getValidIpUsageCfgImpl(ipAddress, null, ipMapLines);
        if (!"".equals(validIp) && null != validIp) {
            return validIp;
        }
        return NATUtility.getInstance().getValidIpImpl(ipAddress, ipMapLines);
    }

    public static String getValidIpUsageCfg(String ipAddress, URI dsURI) {
        return NATUtility.getInstance().getValidIpUsageCfgImpl(ipAddress, dsURI, null);
    }

    public static String getValidIpByKey(String ipAddress, String usage) {
        return NATUtility.getInstance().getValidIpByKeyImpl(ipAddress, usage);
    }

    public static void clearNatConfiguration() {
        log.warn((Object)"clearNatConfiguration start");
        instance = null;
        log.warn((Object)"clearNatConfiguration end");
    }

    static void setHelper(INATUtillityHelper helper) {
        NATUtility.helper = helper;
    }

    static INATUtillityHelper getHelper() {
        if (helper == null) {
            helper = new NATUtilityHelper();
        }
        return helper;
    }

    private String[] getNATIpsImpl(String ipAddress) {
        log.warn((Object)("getNATIps start: ipAddress=" + ipAddress));
        List<String> ipMapLines = this.getIPMapLines();
        String line = this.getHostLineByIPAddress(ipMapLines, ipAddress);
        if (line == null) {
            log.error((Object)String.format("getNATIpsImpl not find the line, will return []", ipAddress));
            return new String[0];
        }
        List<String> ipAddressList = this.getHostAllIPAddressFromLine(line);
        Object[] ipAddressArray = this.convertList2Array(ipAddressList);
        log.warn((Object)("getNATIps end: ipAddressArray=" + Arrays.toString(ipAddressArray)));
        return ipAddressArray;
    }

    private String getValidIpImpl(String ipAddress, List<String> ipMapLines) {
        log.warn((Object)("getValidIp start: ipAddress=" + ipAddress));
        String validIPAddress = null;
        if (this.cache.containsKey(ipAddress)) {
            validIPAddress = this.cache.get(ipAddress);
        } else {
            String line;
            if (ipMapLines == null) {
                ipMapLines = this.getIPMapLines();
            }
            if ((line = this.getHostLineByIPAddress(ipMapLines, ipAddress)) != null) {
                List<String> ipAddressList = this.getHostAllIPAddressFromLine(line);
                validIPAddress = NATUtility.xorIPAddress(ipAddressList, masterIp);
                this.cache.put(ipAddress, validIPAddress);
            }
        }
        log.warn((Object)("getValidIp end: validIPAddress=" + validIPAddress));
        return validIPAddress;
    }

    private String getValidIpUsageCfgImpl(String ipAddress, URI dsURI, List<String> ipMapLines) {
        String line;
        log.warn((Object)String.format("getValidIpUsageCfg start: ipAddress=%s, dsURI=%s", ipAddress, dsURI));
        if (ipMapLines == null) {
            ipMapLines = this.getIPMapLines(dsURI);
        }
        if ((line = this.getHostLineByIPAddress(ipMapLines, ipAddress)) == null) {
            log.error((Object)"getValidIpUsageCfgImpl line=null");
            return null;
        }
        Properties properties = this.convertHostLine2Properties(line);
        String usage = this.getUsage();
        String validIPAddress = properties.getProperty(usage);
        log.warn((Object)("getValidIpUsageCfg end: validIPAddress=" + validIPAddress));
        return validIPAddress;
    }

    private String getValidIpByKeyImpl(String ipAddress, String usage) {
        log.warn((Object)String.format("getValidIpUsageCfg start: ipAddress=%s, usage=%s", ipAddress, usage));
        List<String> ipMapLines = this.getIPMapLines();
        String line = this.getHostLineByIPAddress(ipMapLines, ipAddress);
        if (line == null) {
            log.error((Object)"getValidIpByKeyImpl line=null");
            return null;
        }
        Properties properties = this.convertHostLine2Properties(line);
        String validIP = properties.getProperty(usage);
        log.warn((Object)("getValidIpByKey end: validIP=" + validIP));
        return validIP;
    }

    private String[] convertList2Array(List<String> list) {
        String[] array = new String[]{};
        if (list != null) {
            array = new String[list.size()];
            array = list.toArray(array);
        }
        return array;
    }

    private List<String> getHostAllIPAddressFromLine(String line) {
        String[] temp = line.split(",");
        Vector<String> ipList = new Vector<String>();
        if (temp != null) {
            for (int i = 0; i < temp.length; ++i) {
                String ipAddress;
                if (temp[i].contains("=")) {
                    ipAddress = temp[i].substring(temp[i].indexOf("=") + 1).trim();
                    ipList.add(ipAddress);
                    continue;
                }
                ipAddress = temp[i].trim();
                ipList.add(ipAddress);
            }
        }
        return ipList;
    }

    static String xorIPAddress(List<String> ipAddressList, String loginIPAddress) {
        ArrayList<String> result = new ArrayList<String>();
        ConcurrentHashMap<String, String> xorMap = new ConcurrentHashMap<String, String>();
        try {
            byte[] masterIpBytes = NATUtility.getHelper().convertHost2ByteArray(loginIPAddress);
            for (String aSlaveIp : ipAddressList) {
                byte[] slaveIpBytes = NATUtility.getHelper().convertHost2ByteArray(aSlaveIp);
                String temp = NATUtility.xor(masterIpBytes, slaveIpBytes);
                result.add(temp);
                xorMap.put(temp, aSlaveIp);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        Collections.sort(result);
        return (String)xorMap.get(result.get(0));
    }

    private static String xor(byte[] masterIpBytes, byte[] host2Bytes) {
        String temp = "";
        for (int i = 0; i < masterIpBytes.length; ++i) {
            int result = (byte)(masterIpBytes[i] ^ host2Bytes[i]) & 0xFF;
            temp = result < 10 ? temp + ".00" + result : (result < 100 ? temp + ".0" + result : temp + "." + result);
        }
        temp = temp.substring(1);
        return temp;
    }

    private String getHostLineByIPAddress(List<String> ipMapLines, String ipAddress) {
        String line = null;
        for (String singleIPRow : ipMapLines) {
            List<String> ipList = this.getHostAllIPAddressFromLine(singleIPRow);
            if (!ipList.contains(ipAddress)) continue;
            line = singleIPRow;
            return line;
        }
        log.error((Object)String.format("getHostLineByIPAddress cannot match the ipAddress, ipMapLines=%s, ipAddress=%s", ipMapLines, ipAddress));
        return line;
    }

    private Properties convertHostLine2Properties(String line) {
        Properties properties = new Properties();
        String[] temp = line.split(",");
        if (null != temp) {
            for (String str : temp) {
                int index = str.indexOf("=");
                if (index < 0) continue;
                String key = str.substring(0, index).trim();
                String value = str.substring(index + 1).trim();
                properties.setProperty(key, value);
            }
        }
        return properties;
    }

    private String getUsage() {
        if (this.usage == null) {
            this.usage = NATUtility.getHelper().getUsage();
        }
        log.warn((Object)("getUsage:" + this.usage));
        return this.usage;
    }

    private List<String> getIPMapLines() {
        return this.getIPMapLines(null);
    }

    private List<String> getIPMapLines(URI dsURI) {
        if (this.ipMapLines == null) {
            this.ipMapLines = NATUtility.getHelper().getIPMapLines(dsURI);
        }
        return this.ipMapLines;
    }

    static {
        masterIp = "";
        helper = new NATUtilityHelper();
    }
}

