/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.ValueConvertor;
import com.swimap.base.rpc.XmlHelper;
import com.swimap.base.rpc.bean.BeanHelper;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.NameValuePair;
import com.swimap.external.dsf.base.rpc.RpcParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataTable
implements RpcParameter,
Iterable<DataRecord> {
    private static Log log = LogFactory.getLog(DataTable.class);
    private String name;
    private List<String> columns;
    private List<DataRecord> records;
    private Map<String, RpcParameter> parameters;

    public DataTable(String name) {
        this.name = name;
        this.columns = new ArrayList<String>();
    }

    public DataTable(String name, Class cls) {
        this(name);
        this.setColumns(cls);
    }

    public DataTable(String name, Iterable beans) {
        this(name);
        for (Object bean : beans) {
            this.addBean(bean);
        }
    }

    public DataTable(String name, String[] columns) {
        this(name);
        this.setColumns(columns);
    }

    protected Map<String, RpcParameter> getParaMap() {
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, RpcParameter>();
        }
        return this.parameters;
    }

    public boolean hasParameter() {
        return this.parameters != null && !this.getParaMap().isEmpty();
    }

    public boolean hasParameter(String name) {
        return this.parameters != null && this.getParaMap().containsKey(name);
    }

    public Collection<RpcParameter> getParameters() {
        if (this.parameters != null) {
            return this.parameters.values();
        }
        return null;
    }

    public void addParameter(String name, Object value) {
        NameValuePair item = new NameValuePair(name, value);
        this.getParaMap().put(name, item);
    }

    public void setColumns(String ... columns) {
        this.columns.clear();
        for (String column : columns) {
            if (column == null) continue;
            this.columns.add(column);
        }
    }

    public void setColumns(List<String> columns) {
        this.columns.clear();
        for (String column : columns) {
            if (column == null) continue;
            this.columns.add(column);
        }
    }

    public void setColumns(Class cls) {
        Field[] fields;
        this.columns.clear();
        for (Field field : fields = cls.getFields()) {
            this.columns.add(field.getName());
        }
    }

    public void addColumn(String name) {
        if (name != null) {
            this.columns.add(name);
        }
    }

    protected List<DataRecord> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList<DataRecord>();
        }
        return this.records;
    }

    public int size() {
        if (this.records == null) {
            return 0;
        }
        return this.records.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(DataRecord record) {
        this.getRecords().add(record);
    }

    public void addObject(Object obj) {
        DataRecord record = new DataRecord(this);
        record.copyFrom(obj);
        this.getRecords().add(record);
    }

    public void add(Object ... values) {
        this.getRecords().add(new DataRecord(this, values));
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumnName(int index) {
        return this.columns.get(index);
    }

    public int getColumnIndex(String name) {
        return this.columns.indexOf(name);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public DataRecord get(int row) {
        if (this.records == null || row < 0 || row >= this.records.size()) {
            return null;
        }
        return this.getRecords().get(row);
    }

    public void copyRow(int row, Object obj) {
        if (this.records == null || row < 0 || row >= this.records.size()) {
            return;
        }
        this.getRecords().get(row).copyTo(obj);
    }

    public void addObjectParameter(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getFields()) {
            try {
                Object value = field.get(obj);
                this.addParameter(field.getName(), value);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public void copyParamterTo(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getFields()) {
            try {
                String value = this.getString(field.getName());
                if (value == null) continue;
                field.set(obj, ValueConvertor.convert(value, field.getType()));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.getRecords().iterator();
    }

    @Override
    public String getValue() {
        return this.name;
    }

    public void clear() {
        this.getRecords().clear();
    }

    public String getString(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para != null) {
            return para.getValue();
        }
        return null;
    }

    public double getDouble(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Double.valueOf(para.getValue());
    }

    public Date getDate(String name) {
        try {
            RpcParameter para = this.getParaMap().get(name);
            if (para == null) {
                throw new NullPointerException(name + " not found");
            }
            return ValueConvertor.parseDate(para.getValue());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public int getInt(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Integer.valueOf(para.getValue());
    }

    public long getLong(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Long.valueOf(para.getValue());
    }

    public boolean getBoolean(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para != null) {
            return para.getValue().equals("1");
        }
        return false;
    }

    public int[] getIntArray(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para != null) {
            return ValueConvertor.getIntArray(para.getValue());
        }
        return null;
    }

    public String[] getStringArray(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para != null) {
            return ValueConvertor.getStringArray(para.getValue());
        }
        return null;
    }

    public byte[] getByteArray(String name) {
        RpcParameter para = this.getParaMap().get(name);
        if (para != null) {
            return ValueConvertor.getByteArray(para.getValue());
        }
        return null;
    }

    public DataRecord newRecord() {
        DataRecord record = new DataRecord(this);
        this.getRecords().add(record);
        return record;
    }

    public void addBean(Object bean) {
        if (ValueConvertor.isSupportedType(bean.getClass())) {
            this.addSimpleValue(bean);
        } else {
            this.addJavaBean(bean);
        }
    }

    private void addSimpleValue(Object value) {
        if (this.columns == null || this.columns.size() == 0) {
            this.columns = new ArrayList<String>(1);
            this.columns.add("value");
        }
        DataRecord record = new DataRecord(this);
        record.set(0, value);
        this.getRecords().add(record);
    }

    private void addJavaBean(Object bean) {
        if (this.columns == null || this.columns.size() == 0) {
            this.columns = BeanHelper.getReadablePropertyNames(bean);
        }
        DataRecord record = new DataRecord(this);
        int i = 0;
        for (String columnName : this.columns) {
            Object value = BeanHelper.getProperty(bean, columnName);
            if (value instanceof Collection) {
                value = new DataTable(columnName, (Collection)value);
            }
            record.set(i++, value);
        }
        this.getRecords().add(record);
    }

    public <T> T getBean(int row, Class<T> cls) {
        if (this.records == null || row < 0 || row >= this.records.size()) {
            return null;
        }
        return this.getRecords().get(row).asBean(cls);
    }

    public <T> List<T> asListOf(Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>(this.size());
        if (this.records != null) {
            for (DataRecord record : this.records) {
                list.add(record.asBean(cls));
            }
        }
        return list;
    }

    public <T> Iterable<T> asIterable(Class<T> beanClass) {
        return new BeanIterable<T>(beanClass);
    }

    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            TransformerHandler hd = XmlHelper.getTransformerHandler(ba);
            hd.startDocument();
            XmlHelper.writeDataTable(hd, this);
            hd.endDocument();
            return ba.toString("UTF-8");
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static DataTable parseXML(String xml) throws Exception {
        return XmlHelper.parseDataTable(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    private class BeanIterable<T>
    implements Iterable<T> {
        private Class<T> beanClass;

        BeanIterable(Class<T> beanClass) {
            this.beanClass = beanClass;
        }

        @Override
        public Iterator<T> iterator() {
            return new BeanIterator<T>(this.beanClass);
        }
    }

    private class BeanIterator<T>
    implements Iterator<T> {
        private Iterator<DataRecord> iterator;
        private Class<T> beanClass;

        BeanIterator(Class<T> beanClass) {
            this.iterator = DataTable.this.iterator();
            this.beanClass = beanClass;
        }

        @Override
        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public final T next() {
            return this.iterator.next().asBean(this.beanClass);
        }

        @Override
        public final void remove() {
            this.iterator.remove();
        }
    }
}

