/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.ValueConvertor;
import com.swimap.base.rpc.XmlHelper;
import com.swimap.base.rpc.bean.BeanHelper;
import com.swimap.external.dsf.base.rpc.DataTable;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRecord {
    private static Log log = LogFactory.getLog(DataRecord.class);
    private DataTable owner;
    private String[] values;
    private Map<String, DataTable> tables;

    public DataRecord(DataTable owner) {
        this.owner = owner;
        this.values = new String[owner.getColumnCount()];
    }

    public DataRecord(DataTable owner, Object ... initValues) {
        this(owner);
        this.values = new String[owner.getColumnCount()];
        for (int i = 0; i < this.values.length; ++i) {
            if (i >= initValues.length) continue;
            this.set(i, initValues[i]);
        }
    }

    public void copyFrom(Object obj) {
        Field[] fields = obj.getClass().getFields();
        int index = 0;
        for (Field field : fields) {
            index = this.owner.getColumnIndex(field.getName());
            if (index < 0) continue;
            try {
                this.set(index, field.get(obj));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public void copyTo(Object obj) {
        Field[] fields = obj.getClass().getFields();
        int index = 0;
        for (Field field : fields) {
            index = this.owner.getColumnIndex(field.getName());
            if (index < 0) continue;
            Object value = ValueConvertor.convert(this.get(index), field.getType());
            try {
                field.set(obj, value);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public DataTable getOwner() {
        return this.owner;
    }

    public String[] getValues() {
        return this.values;
    }

    public String get(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public String get(int index) {
        if (index < 0 || index >= this.values.length) {
            return null;
        }
        return this.values[index];
    }

    public int getInt(String name) {
        int index = this.owner.getColumnIndex(name);
        return this.getInt(index);
    }

    public int getInt(int index) {
        return Integer.valueOf(this.values[index]);
    }

    public long getLong(String name) {
        int index = this.owner.getColumnIndex(name);
        return this.getLong(index);
    }

    public long getLong(int index) {
        return Long.valueOf(this.values[index]);
    }

    public boolean getBoolean(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return false;
        }
        return this.getBoolean(index);
    }

    public boolean getBoolean(int index) {
        if (index < 0 || index >= this.values.length) {
            return false;
        }
        return this.values[index].equals("1");
    }

    public double getDouble(int index) {
        return Double.valueOf(this.values[index]);
    }

    public double getDouble(String name) {
        int index = this.owner.getColumnIndex(name);
        return this.getDouble(index);
    }

    public Date getDate(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.getDate(index);
    }

    public Date getDate(int index) {
        try {
            return ValueConvertor.parseDate(this.values[index]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getIntArray(int index) {
        try {
            return ValueConvertor.getIntArray(this.values[index]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getIntArray(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.getIntArray(index);
    }

    public String[] getStringArray(int index) {
        try {
            return ValueConvertor.getStringArray(this.values[index]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getStringArray(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.getStringArray(index);
    }

    public byte[] getByteArray(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.getByteArray(index);
    }

    public byte[] getByteArray(int index) {
        return ValueConvertor.getByteArray(this.values[index]);
    }

    public void set(String name, Object value) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return;
        }
        this.set(index, value);
    }

    public DataTable getTable(String name) {
        int index = this.owner.getColumnIndex(name);
        if (index < 0) {
            return null;
        }
        return this.getTable(index);
    }

    public DataTable getTable(int index) {
        String key;
        if (this.tables != null && (key = this.get(index)) != null) {
            return this.tables.get(this.get(index));
        }
        return null;
    }

    public boolean hasTable() {
        return this.tables != null && !this.tables.isEmpty();
    }

    public void set(int index, Object value) {
        if (index < 0 || index >= this.values.length) {
            return;
        }
        if (value instanceof DataTable) {
            DataTable table = (DataTable)value;
            this.values[index] = table.getName();
            this.addTable(table);
        } else {
            this.values[index] = ValueConvertor.valueToString(value);
        }
    }

    public Map<String, DataTable> getTables() {
        if (this.tables == null) {
            this.tables = new HashMap<String, DataTable>();
        }
        return this.tables;
    }

    public void addTable(DataTable table) {
        this.getTables().put(table.getName(), table);
    }

    public final void setValue(int index, String value) {
        this.values[index] = value;
    }

    public int size() {
        return this.values.length;
    }

    public <T> T asBean(Class<T> beanClass) {
        if (ValueConvertor.isSupportedType(beanClass)) {
            if (this.values.length == 0) {
                return null;
            }
            return beanClass.cast(ValueConvertor.convert(this.values[0], beanClass));
        }
        T bean = BeanHelper.createBean(beanClass);
        for (int i = 0; i < this.values.length; ++i) {
            String name = this.owner.getColumnName(i);
            Class<?> valueType = BeanHelper.getPropertyType(bean, name);
            if (Collection.class.isAssignableFrom(valueType)) {
                this.setCollectionProperty(bean, name, this.getTable(i), valueType);
                continue;
            }
            this.setSimpleProperty(bean, name, this.values[i], valueType);
        }
        return bean;
    }

    private void setSimpleProperty(Object bean, String name, Object value, Class<?> valueType) {
        value = ValueConvertor.convert(value, valueType);
        if (valueType.isPrimitive()) {
            BeanHelper.setProperty(bean, name, value);
        } else {
            BeanHelper.setProperty(bean, name, valueType.cast(value));
        }
    }

    private void setCollectionProperty(Object bean, String name, DataTable table, Class<?> valueType) {
        Class<?> elementType = BeanHelper.getElementType(bean, name);
        BeanHelper.setProperty(bean, name, this.getCollectionFromTable(table, valueType, elementType));
    }

    private <T> T getCollectionFromTable(DataTable table, Class<T> valueType, Class<?> elementType) {
        if (table == null || valueType == null || elementType == null) {
            return null;
        }
        AbstractCollection value = null;
        if (valueType.equals(List.class)) {
            value = new ArrayList(table.size());
        } else if (valueType.equals(Set.class)) {
            value = new HashSet(table.size());
        } else if (!valueType.isInterface()) {
            value = BeanHelper.createBean(valueType);
        } else {
            return null;
        }
        int tableSize = table.size();
        for (int i = 0; i < tableSize; ++i) {
            ((Collection)value).add(table.getBean(i, elementType));
        }
        return (T)value;
    }

    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            TransformerHandler hd = XmlHelper.getTransformerHandler(ba);
            hd.startDocument();
            XmlHelper.writeDataRecord(hd, this);
            hd.endDocument();
            return ba.toString("UTF-8");
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

