/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.framework;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.Framework;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class LocaleResource {
    private static Log log = LogFactory.getLog(LocaleResource.class);
    private static final String suffix = ".properties";
    private ResourceBundle rb = null;
    private static final int UTF8_MAGIC_1 = 239;
    private static final int UTF8_MAGIC_2 = 187;
    private static final int UTF8_MAGIC_3 = 191;
    public String encoding = System.getProperty("file.encoding");

    public LocaleResource(BundleContext context, String fileName) throws Exception {
        String locale = Locale.getDefault().toString();
        String budleName = context.getBundle().getSymbolicName();
        String root = Framework.getBundleDir() + File.separator + budleName;
        if (locale != null) {
            String resPath = root + "/res/" + locale + '/' + fileName + suffix;
            this.initPropertyResourceBundle(resPath);
        } else {
            log.warn((Object)"Don't set the locale,so the resources file don't foud !");
        }
    }

    public LocaleResource(String absolutePath) throws Exception {
        this.initPropertyResourceBundle(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPropertyResourceBundle(String resPath) throws Exception {
        if (!FileUtil.checkReadFile(resPath)) {
            throw new Exception("check resPath failed.");
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(resPath));
            if (this.encoding.equalsIgnoreCase("utf-8")) {
                boolean noBOM;
                in.mark(0);
                int b1 = in.read();
                int b2 = in.read();
                int b3 = in.read();
                boolean bl = noBOM = b1 != 239 || b2 != 187 || b3 != 191;
                if (noBOM) {
                    in.reset();
                }
            }
            this.rb = new PropertyResourceBundle(new InputStreamReader(in));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    public String getResourceValue(String keyName) {
        String value = null;
        if (keyName == null) {
            log.warn((Object)"keyName is null");
            return null;
        }
        try {
            if (this.rb != null) {
                value = this.rb.getString(keyName);
            } else {
                log.warn((Object)"Don't found the resources.");
            }
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
        return value;
    }
}

