/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AppError
extends Exception {
    private static final String STRING_SEPARATOR = "\r";
    private static final String ERROR_CODE = "com.swimap.base.framework.apperror.errorcode";
    private static final String ERROR_DESC = "com.swimap.base.framework.apperror.errordesc";
    public static final int APP_ERROR_UNKNOW = 9999;
    public static final String APP_ERROR_UNKNOW_DES = "AppError unknow error";
    private String name;
    private Map<String, Info> detail;

    public AppError(String name) {
        this.name = name;
    }

    public AppError(String name, List<Info> detail) {
        this.name = name;
        if (detail != null) {
            for (Info info : detail) {
                this.addDetail(info.id, info.message);
            }
        }
    }

    public boolean is(String name) {
        return this.name.equals(name);
    }

    public String getName() {
        return this.name;
    }

    public Collection<Info> getDetail() {
        if (this.detail != null) {
            return this.detail.values();
        }
        return Collections.emptyList();
    }

    public void addDetail(String id, String message) {
        if (this.detail == null) {
            this.detail = new ConcurrentHashMap<String, Info>();
        }
        this.detail.put(id, new Info(id, message));
    }

    public void addDetail(String id, String[] array) {
        if (this.detail == null) {
            this.detail = new ConcurrentHashMap<String, Info>();
        }
        this.detail.put(id, new Info(id, AppError.array2string(array)));
    }

    public String getDetail(String id) {
        Info info;
        if (this.detail != null && (info = this.detail.get(id)) != null) {
            return info.message;
        }
        return null;
    }

    public String[] getDetailAsArray(String id) {
        Info info;
        if (this.detail != null && (info = this.detail.get(id)) != null) {
            return AppError.string2array(info.message);
        }
        return null;
    }

    public boolean hasDetail() {
        return this.detail != null;
    }

    public boolean hasDetail(String id) {
        if (this.detail != null) {
            return this.detail.containsKey(id);
        }
        return false;
    }

    public int getDetailCount() {
        if (this.detail != null) {
            return this.detail.size();
        }
        return 0;
    }

    private static String array2string(String[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(STRING_SEPARATOR);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    private static String[] string2array(String str) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        return str.split(STRING_SEPARATOR);
    }

    public int getInternalErrorCode() {
        String errorCode = this.getDetail(ERROR_CODE);
        if (errorCode == null) {
            return 9999;
        }
        return Integer.parseInt(errorCode);
    }

    public void setInternalErrorCode(int internalErrorCode) {
        this.addDetail(ERROR_CODE, "" + internalErrorCode);
    }

    public String getInternalErrorDesc() {
        String detail = this.getDetail(ERROR_DESC);
        if (detail != null) {
            return detail;
        }
        return APP_ERROR_UNKNOW_DES;
    }

    public void setInternalErrorDesc(String internalErrorDesc) {
        this.addDetail(ERROR_DESC, "" + internalErrorDesc);
    }

    public static class Info {
        public String id;
        public String message;

        public Info(String id, String message) {
            this.id = id;
            this.message = message;
        }
    }
}

