/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.proxy;

import com.swimap.base.rpc.proxy.Proxy;
import com.swimap.base.rpc.proxy.ProxyRequestEntity;
import com.swimap.base.rpc.proxy.ProxyRewriter;
import com.swimap.base.rpc.proxy.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcProxyServlet
implements Servlet {
    private static Log log = LogFactory.getLog(RpcProxyServlet.class);
    private ServletConfig config;
    private HttpClient client;
    private Proxy proxy;
    private static HashSet<String> noProxyHeaders = new HashSet();
    private static HttpClient sharedClient;

    RpcProxyServlet(Proxy proxy) {
        this.proxy = proxy;
        this.client = RpcProxyServlet.getClient();
    }

    static synchronized HttpClient getClient() {
        if (sharedClient == null) {
            sharedClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            sharedClient.getParams().setCookiePolicy("ignoreCookies");
        }
        return sharedClient;
    }

    public void init(ServletConfig config) {
        this.config = config;
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "RpcProxyServlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse rsp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rsp;
        HttpMethodBase method = this.getHttpMethod(request);
        if (method == null) {
            response.sendError(405, "Method " + request.getMethod() + " not supported.");
            log.warn((Object)(request.getMethod() + " method not supported by proxy."));
            return;
        }
        try {
            Header[] headers;
            boolean xForwardedFor = false;
            Enumeration enm = request.getHeaderNames();
            String headerName = null;
            String lHeaderName = null;
            String headerValue = null;
            while (enm.hasMoreElements()) {
                headerName = (String)enm.nextElement();
                lHeaderName = headerName.toLowerCase();
                if (noProxyHeaders.contains(lHeaderName)) continue;
                headerValue = request.getHeader(headerName);
                method.addRequestHeader(headerName, headerValue);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(headerName);
            }
            method.addRequestHeader("Via", "1.1 (RpcProxyServlet)");
            if (!xForwardedFor) {
                method.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
            }
            this.client.executeMethod((HttpMethod)method);
            response.setStatus(method.getStatusCode());
            response.setHeader("Date", null);
            response.setHeader("Server", null);
            Header contentType = method.getResponseHeader("Content-Type");
            boolean rewriteURL = this.needRewriteURL(contentType);
            for (Header header : headers = method.getResponseHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                if (noProxyHeaders.contains(name) || rewriteURL && "Content-Length".equalsIgnoreCase(name)) continue;
                if ("Location".equalsIgnoreCase(name) || "Content-Location".equalsIgnoreCase(name)) {
                    value = this.mapLocation(value);
                }
                response.addHeader(name, value);
            }
            response.addHeader("Via", "1.1 (RpcProxyServlet)");
            if (rewriteURL) {
                try {
                    ProxyRewriter.rewriteURL(this.proxy, method.getResponseBodyAsStream(), (OutputStream)response.getOutputStream(), method.getRequestCharSet());
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    log.warn((Object)"", (Throwable)e);
                    response.sendError(500, "Proxy url rewrite failed!");
                }
            } else {
                Util.copyStream(method.getResponseBodyAsStream(), (OutputStream)response.getOutputStream());
            }
            response.flushBuffer();
        }
        finally {
            method.releaseConnection();
        }
    }

    private String mapLocation(String location) {
        if (location.charAt(0) == '/') {
            return this.proxy.getPath() + location;
        }
        if (location.startsWith(this.proxy.getLocation())) {
            return this.proxy.getPath() + location.substring(this.proxy.getLocation().length());
        }
        return location;
    }

    private boolean needRewriteURL(Header contentType) {
        if (!this.proxy.hasUrlMap()) {
            return false;
        }
        return contentType != null && (contentType.getValue().startsWith("text/html") || contentType.getValue().startsWith("application/xhtml"));
    }

    private HttpMethodBase getHttpMethod(HttpServletRequest request) throws IOException {
        String queryString;
        StringBuilder url = new StringBuilder(this.proxy.getLocation());
        String path = request.getPathInfo();
        if (path != null) {
            url.append(path);
        }
        if ((queryString = request.getQueryString()) != null) {
            url.append('?');
            url.append(queryString);
        }
        if ("GET".equals(request.getMethod())) {
            GetMethod get = new GetMethod(url.toString());
            return get;
        }
        if ("POST".equals(request.getMethod())) {
            PostMethod post = new PostMethod(url.toString());
            post.setRequestEntity((RequestEntity)new ProxyRequestEntity(request));
            return post;
        }
        return null;
    }

    static {
        noProxyHeaders.add("connection");
        noProxyHeaders.add("keep-alive");
        noProxyHeaders.add("transfer-encoding");
        noProxyHeaders.add("accept-encoding");
        noProxyHeaders.add("te");
        noProxyHeaders.add("trailer");
        noProxyHeaders.add("proxy-connection");
        noProxyHeaders.add("proxy-authorization");
        noProxyHeaders.add("proxy-authenticate");
        noProxyHeaders.add("upgrade");
    }
}

