/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.proxy;

import com.swimap.base.rpc.proxy.Proxy;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.htmlparser.Parser;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.visitors.NodeVisitor;

final class ProxyRewriter
extends NodeVisitor {
    private Proxy proxy;
    private PrintStream out;
    private OutputStream stream;
    private static final String[] REWRITE_ATTRS = new String[]{"href", "src", "action", "value", "url"};

    protected ProxyRewriter(Proxy proxy, OutputStream stream, String charset) throws Exception {
        this.proxy = proxy;
        this.stream = stream;
        this.out = new PrintStream(stream, true, charset);
    }

    public static void rewriteURL(Proxy proxy, InputStream input, OutputStream output, String charset) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Parser parser = new Parser(new Lexer(new Page(input, charset)));
        ProxyRewriter rewriter = new ProxyRewriter(proxy, buffer, charset);
        try {
            parser.visitAllNodesWith((NodeVisitor)rewriter);
        }
        catch (EncodingChangeException e) {
            parser.reset();
            buffer.reset();
            parser.visitAllNodesWith((NodeVisitor)rewriter);
        }
        buffer.writeTo(output);
    }

    public void visitRemarkNode(Remark remarkNode) {
        this.out.print(remarkNode.toHtml());
    }

    public void visitStringNode(Text stringNode) {
        this.out.print(stringNode.toHtml());
    }

    private String newURL(String url) {
        List<Proxy.UrlMap> maps = this.proxy.getUrlMaps();
        for (Proxy.UrlMap map : maps) {
            if (!url.startsWith(map.from)) continue;
            return map.to + url.substring(map.from.length());
        }
        return null;
    }

    private void rewriteURL(Tag tag, String attrName) {
        String newurl;
        String url = tag.getAttribute(attrName);
        if (url != null && (newurl = this.newURL(url)) != null) {
            tag.setAttribute(attrName, newurl);
        }
    }

    public void visitTag(Tag tag) {
        for (String attr : REWRITE_ATTRS) {
            this.rewriteURL(tag, attr);
        }
        this.out.print(tag.toTagHtml());
        if (tag instanceof MetaTag) {
            MetaTag metaTag = (MetaTag)tag;
            this.setCharsetByMeta(metaTag);
        }
    }

    private void setCharsetByMeta(MetaTag metaTag) {
        String[] split;
        String content;
        if ("content-type".equalsIgnoreCase(metaTag.getHttpEquiv()) && (content = metaTag.getMetaContent()) != null && (split = content.split("charset=")).length == 2) {
            String charset = split[1];
            this.out.flush();
            try {
                this.out = new PrintStream(this.stream, true, charset);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    public void visitEndTag(Tag tag) {
        this.out.print(tag.toHtml());
    }
}

