/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.proxy;

import com.swimap.base.framework.Framework;
import com.swimap.base.rpc.proxy.RpcProxyServlet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Proxy {
    private static Log log = LogFactory.getLog(Proxy.class);
    private String path;
    private String location;
    private List<UrlMap> urlMaps;
    private RpcProxyServlet servlet;

    public Proxy(String path, String location) {
        this.path = path;
        this.location = location;
    }

    public String getPath() {
        return this.path;
    }

    public String getLocation() {
        return this.location;
    }

    public void mapURL(String from, String to) {
        if (this.urlMaps == null) {
            this.urlMaps = new ArrayList<UrlMap>();
        }
        this.urlMaps.add(new UrlMap(from, to));
    }

    boolean hasUrlMap() {
        return this.urlMaps != null && !this.urlMaps.isEmpty();
    }

    List<UrlMap> getUrlMaps() {
        return this.urlMaps;
    }

    public Servlet getServlet() {
        if (this.servlet == null) {
            this.servlet = new RpcProxyServlet(this);
        }
        return this.servlet;
    }

    public static Collection<Proxy> loadProxies() {
        try {
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            File file = new File(Framework.getConfigDir(), "proxy.xml");
            if (!file.exists()) {
                return proxies;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(file);
            if (!"proxies".equals(dom.getDocumentElement().getNodeName())) {
                throw new Exception("No <proxies> tag found in proxy.xml.");
            }
            NodeList proxyNodeList = dom.getElementsByTagName("proxy");
            int mapNodesLength = 0;
            Node proxyNode = null;
            String path = null;
            String location = null;
            Proxy proxy = null;
            NodeList mapNodes = null;
            Node mapNode = null;
            for (int i = 0; i < proxyNodeList.getLength(); ++i) {
                proxyNode = proxyNodeList.item(i);
                path = Proxy.getAttribute(proxyNode, "path");
                location = Proxy.getAttribute(proxyNode, "location");
                proxy = new Proxy(path, location);
                mapNodes = proxyNode.getChildNodes();
                mapNodesLength = mapNodes.getLength();
                for (int n = 0; n < mapNodesLength; ++n) {
                    mapNode = mapNodes.item(n);
                    if (!"map-url".equals(mapNode.getNodeName())) continue;
                    String from = Proxy.getAttribute(mapNode, "from");
                    String to = Proxy.getAttribute(mapNode, "to");
                    proxy.mapURL(from, to);
                }
                proxies.add(proxy);
            }
            return proxies;
        }
        catch (Exception e) {
            log.error((Object)("Load proxy.xml failed: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    private static String getAttribute(Node node, String name) throws Exception {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            throw new Exception("Attribute '" + name + "' not found in '" + node.getNodeName() + "' tag.");
        }
        return attr.getNodeValue();
    }

    static class UrlMap {
        String from;
        String to;

        UrlMap(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

