/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.StopDsThread;
import com.swimap.base.rpc.RpcAcceptProtect;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.ThreadPool;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolWatchdog
implements Runnable {
    private static Log log = LogFactory.getLog(ThreadPoolWatchdog.class);
    public static final String ENABLE_THREADPOOL_WATCHDOG = "enableThreadPoolWatchdog";
    private static volatile int currentNum = 0;
    private boolean running;
    private Thread thread;
    private ThreadPool[] pools = new ThreadPool[]{new ThreadPool(ThreadPoolManager.getInstance().getReadThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getTaskThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getAcceptThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getMrbServerTaskThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getMSGTaskThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getWriteThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getEventThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getServerPushThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getSingleThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getMrbReadSingleThreadPool()), new ThreadPool(ThreadPoolManager.getInstance().getAssistPool())};

    public void start() {
        if (!this.running) {
            this.running = true;
            this.thread = new Thread((Runnable)this, "ThreadPoolWatchdog");
            this.thread.setPriority(10);
            this.thread.start();
            log.info((Object)"ThreadPoolWatchdog Started!");
        }
    }

    static int getCurrentNum() {
        return currentNum;
    }

    public void stop() {
        if (this.running && this.thread != null) {
            this.running = false;
            this.thread.interrupt();
            this.thread = null;
            log.info((Object)"ThreadPoolWatchdog Stopped!");
        }
    }

    private void printClientNumber() {
        log.warn((Object)("Current clients number: " + Clients.getClientCount()));
    }

    @Override
    public void run() {
        int poolLockTimeOut = Integer.getInteger("imap.watchdog.poolTimeout", 15);
        int checkInterval = Integer.getInteger("imap.watchdog.checkInterval", 60000);
        while (true) {
            ++currentNum;
            this.printClientNumber();
            for (int i = 0; i < this.pools.length; ++i) {
                ThreadPool pool = this.pools[i];
                if (currentNum - pool.getTimeStamp() > poolLockTimeOut) {
                    FrameInformationManager.getInstance().record("Ds thread pool", "Checking ds thread pool lock time", false);
                    StopDsThread stop = new StopDsThread("Stop_ds", 10000L);
                    stop.start();
                    pool.dumpThread();
                    log.debug((Object)(pool + " is blocking so lang time, system will exit"));
                    continue;
                }
                if (currentNum == Integer.MAX_VALUE) {
                    currentNum = 0;
                }
                pool.healthCheck();
            }
            RpcAcceptProtect.getInstance().readInvalidIPAddressList();
            try {
                Thread.sleep(checkInterval);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

