/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.DefaultThreadFactory;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private ThreadPoolExecutor readThreadPool;
    private QueuedThreadPool taskThreadPool;
    private QueuedThreadPool acceptThreadPool;
    private QueuedThreadPool mrbtaskThreadPool;
    private QueuedThreadPool msgtaskThreadPool;
    private QueuedThreadPool writeThreadPool;
    private ThreadPoolExecutor eventThreadPool;
    private ThreadPoolExecutor serverPushThreadPool;
    private ThreadPoolExecutor singleThreadPool;
    private ThreadPoolExecutor mrbReadSingleThreadPool;
    private QueuedThreadPool assistPool;
    private QueuedThreadPool assistPoolLogin;
    private QueuedThreadPool assistPoolAlarm;
    private int maxPoolSize = 100;
    private int readPoolSize = 10;
    private int writePoolSize = 10;
    private int mrbPoolSize = 10;
    private static ThreadPoolManager instance;

    public static ThreadPoolManager getInstance() {
        if (instance == null) {
            instance = new ThreadPoolManager();
        }
        return instance;
    }

    private ThreadPoolManager() {
        String max = System.getProperty("imap.rpc.maxPoolSize", "50");
        String r_size = System.getProperty("imap.rpc.readPoolsize");
        String w_size = null;
        if (System.getProperty("imap.rpc.connectors") == null) {
            w_size = System.getProperty("imap.rpc.writePoolsize", "1");
        }
        if (max != null) {
            this.maxPoolSize = Integer.valueOf(max);
        }
        if (r_size != null) {
            this.readPoolSize = Integer.valueOf(r_size);
        }
        if (w_size != null) {
            this.writePoolSize = Integer.valueOf(w_size);
        }
    }

    public synchronized QueuedThreadPool getTaskThreadPool() {
        if (this.taskThreadPool == null) {
            this.taskThreadPool = new QueuedThreadPool();
            this.taskThreadPool.setMaxThreads(this.maxPoolSize);
            this.taskThreadPool.setMaxQueued(5000);
            this.taskThreadPool.setDaemon(true);
            this.taskThreadPool.setName("task_pool");
            this.taskThreadPool.start();
        }
        return this.taskThreadPool;
    }

    public synchronized QueuedThreadPool getAcceptThreadPool() {
        if (this.acceptThreadPool == null) {
            this.acceptThreadPool = new QueuedThreadPool();
            this.acceptThreadPool.setMaxThreads(5);
            this.acceptThreadPool.setMaxQueued(500);
            this.acceptThreadPool.setDaemon(true);
            this.acceptThreadPool.setName("accept_pool");
            this.acceptThreadPool.start();
        }
        return this.acceptThreadPool;
    }

    public void setReadThreadPool(ThreadPoolExecutor readThreadPool) {
        if (this.readThreadPool == null) {
            this.readThreadPool = readThreadPool;
        }
    }

    public void setTaskThreadPool(QueuedThreadPool taskThreadPool) {
        if (this.taskThreadPool == null) {
            this.taskThreadPool = taskThreadPool;
        }
    }

    public void setWriteThreadPool(QueuedThreadPool writeThreadPool) {
        if (this.writeThreadPool == null) {
            this.writeThreadPool = writeThreadPool;
        }
    }

    public void setEventThreadPool(ThreadPoolExecutor eventThreadPool) {
        if (this.eventThreadPool == null) {
            this.eventThreadPool = eventThreadPool;
        }
    }

    public void setServerPushThreadPool(ThreadPoolExecutor serverPushThreadPool) {
        if (this.serverPushThreadPool == null) {
            this.serverPushThreadPool = serverPushThreadPool;
        }
    }

    public void setSingleThreadPool(ThreadPoolExecutor singleThreadPool) {
        if (this.singleThreadPool == null) {
            this.singleThreadPool = singleThreadPool;
        }
    }

    public synchronized QueuedThreadPool getMrbServerTaskThreadPool() {
        if (this.mrbtaskThreadPool == null) {
            this.mrbtaskThreadPool = new QueuedThreadPool();
            this.mrbtaskThreadPool.setMaxThreads(this.mrbPoolSize);
            this.mrbtaskThreadPool.setMaxQueued(5000);
            this.mrbtaskThreadPool.setDaemon(true);
            this.mrbtaskThreadPool.setName("MrbServer_pool");
            this.mrbtaskThreadPool.start();
        }
        return this.mrbtaskThreadPool;
    }

    public synchronized QueuedThreadPool getMSGTaskThreadPool() {
        if (this.msgtaskThreadPool == null) {
            this.msgtaskThreadPool = new QueuedThreadPool();
            this.msgtaskThreadPool.setMaxThreads(this.mrbPoolSize);
            this.msgtaskThreadPool.setMaxQueued(5000);
            this.msgtaskThreadPool.setDaemon(true);
            this.msgtaskThreadPool.setName("MsgDispatch_pool");
            this.msgtaskThreadPool.start();
        }
        return this.msgtaskThreadPool;
    }

    public synchronized ThreadPoolExecutor getReadThreadPool() {
        if (this.readThreadPool == null) {
            this.readThreadPool = new ThreadPoolExecutor(this.readPoolSize, this.readPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            DefaultThreadFactory factory = new DefaultThreadFactory("@RP");
            this.readThreadPool.setThreadFactory(factory);
        }
        return this.readThreadPool;
    }

    public synchronized QueuedThreadPool getWriteThreadPool() {
        if (this.writeThreadPool == null) {
            this.writeThreadPool = new QueuedThreadPool();
            this.writeThreadPool.setMaxThreads(this.writePoolSize);
            this.writeThreadPool.setMaxQueued(5000);
            this.writeThreadPool.setName("write_pool");
            this.writeThreadPool.setDaemon(true);
            this.writeThreadPool.start();
        }
        return this.writeThreadPool;
    }

    public QueuedThreadPool getOneWriteThreadPool(String name) {
        QueuedThreadPool oneWriteThreadPool = new QueuedThreadPool();
        oneWriteThreadPool.setMaxThreads(1);
        oneWriteThreadPool.setMaxQueued(5000);
        oneWriteThreadPool.setName("write_pool_" + name);
        oneWriteThreadPool.setDaemon(true);
        oneWriteThreadPool.start();
        return oneWriteThreadPool;
    }

    public synchronized ThreadPoolExecutor getEventThreadPool() {
        if (this.eventThreadPool == null) {
            this.eventThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            DefaultThreadFactory factory = new DefaultThreadFactory("@EP");
            this.eventThreadPool.setThreadFactory(factory);
        }
        return this.eventThreadPool;
    }

    public synchronized ThreadPoolExecutor getServerPushThreadPool() {
        if (this.serverPushThreadPool == null) {
            this.serverPushThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            DefaultThreadFactory factory = new DefaultThreadFactory("@SP");
            this.serverPushThreadPool.setThreadFactory(factory);
        }
        return this.serverPushThreadPool;
    }

    public synchronized ThreadPoolExecutor getSingleThreadPool() {
        if (this.singleThreadPool == null) {
            this.singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        DefaultThreadFactory factory = new DefaultThreadFactory("@ER");
        this.singleThreadPool.setThreadFactory(factory);
        return this.singleThreadPool;
    }

    public synchronized ThreadPoolExecutor getMrbReadSingleThreadPool() {
        if (this.mrbReadSingleThreadPool == null) {
            this.mrbReadSingleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        DefaultThreadFactory factory = new DefaultThreadFactory("@MR");
        this.mrbReadSingleThreadPool.setThreadFactory(factory);
        return this.mrbReadSingleThreadPool;
    }

    public synchronized QueuedThreadPool getAssistPool() {
        if (this.assistPool == null) {
            this.assistPool = new QueuedThreadPool();
            this.assistPool.setMaxThreads(5);
            this.assistPool.setMaxQueued(500);
            this.assistPool.setDaemon(true);
            this.assistPool.setName("assist_pool");
            this.assistPool.start();
        }
        return this.assistPool;
    }

    public void shutdowAll() throws Exception {
        if (this.readThreadPool != null) {
            this.readThreadPool.shutdown();
            this.readThreadPool = null;
        }
        if (this.taskThreadPool != null) {
            this.taskThreadPool.stop();
            this.taskThreadPool = null;
        }
        if (this.eventThreadPool != null) {
            this.eventThreadPool.shutdown();
            this.eventThreadPool = null;
        }
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdown();
            this.singleThreadPool = null;
        }
        if (this.mrbReadSingleThreadPool != null) {
            this.mrbReadSingleThreadPool.shutdown();
            this.mrbReadSingleThreadPool = null;
        }
        if (this.assistPool != null) {
            this.assistPool.stop();
            this.assistPool = null;
        }
        instance = null;
    }

    public synchronized QueuedThreadPool getAssistPoolLogin() {
        if (this.assistPoolLogin == null) {
            this.assistPoolLogin = new QueuedThreadPool();
            this.assistPoolLogin.setMaxThreads(10);
            this.assistPoolLogin.setMaxQueued(200);
            this.assistPoolLogin.setDaemon(true);
            this.assistPoolLogin.setName("assist_pool_login");
            this.assistPoolLogin.start();
        }
        return this.assistPoolLogin;
    }

    public synchronized QueuedThreadPool getAssistPoolAlarm() {
        if (this.assistPoolAlarm == null) {
            this.assistPoolAlarm = new QueuedThreadPool();
            this.assistPoolAlarm.setMaxThreads(20);
            this.assistPoolAlarm.setMaxQueued(200);
            this.assistPoolAlarm.setDaemon(true);
            this.assistPoolAlarm.setName("assist_pool_alarm");
            this.assistPoolAlarm.start();
        }
        return this.assistPoolAlarm;
    }

    public String getPoolInformation(ThreadPoolExecutor threadPool) {
        int sizeQueue = threadPool.getQueue().size();
        int sizeMax = threadPool.getMaximumPoolSize();
        int sizeMin = threadPool.getCorePoolSize();
        int sizeWorkThread = threadPool.getActiveCount();
        StringBuilder ss = new StringBuilder("QueueSize:").append(sizeQueue);
        ss.append("; Work thread:").append(sizeWorkThread);
        ss.append("; Max  thread:").append(sizeMax);
        ss.append("; Min  thread:").append(sizeMin);
        return ss.toString();
    }
}

