/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.framework.watchdog.Util;
import com.swimap.base.rpc.nio.DefaultThreadFactory;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.ThreadPoolWatchdog;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ThreadPool {
    private static Log log = LogFactory.getLog(ThreadPool.class);
    private volatile int timeStamp = 0;
    private Object pool = null;

    public ThreadPool(Object threadPool) {
        this.pool = threadPool;
    }

    public void dumpThread() {
        if (this.pool == null) {
            return;
        }
        if (this.pool instanceof QueuedThreadPool) {
            QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.pool;
            String name = queuedThreadPool.getName();
            this.logStacks(this.getThreads(name));
        } else if (this.pool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.pool;
            ThreadFactory fac = threadPoolExecutor.getThreadFactory();
            if (fac instanceof DefaultThreadFactory) {
                DefaultThreadFactory sfc = (DefaultThreadFactory)fac;
                this.logStacks(this.getThreads(sfc.getNamePrefix()));
            } else {
                this.logStacks(this.getThreads(null));
            }
        }
    }

    public List<ThreadInfo> getThreads(String poolname) {
        LinkedList<ThreadInfo> threadList = new LinkedList<ThreadInfo>();
        try {
            ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
            tmx.setThreadContentionMonitoringEnabled(true);
            ThreadInfo[] infos = tmx.dumpAllThreads(true, true);
            for (int i = 0; i < infos.length; ++i) {
                ThreadInfo info = infos[i];
                if (poolname != null) {
                    if (info.getThreadName().indexOf(poolname) < 0) continue;
                    threadList.add(info);
                    continue;
                }
                threadList.add(info);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return threadList;
    }

    public void healthCheck() {
        if (this.pool == null) {
            return;
        }
        if (this.pool instanceof QueuedThreadPool) {
            QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.pool;
            queuedThreadPool.dispatch(new Thread(){

                @Override
                public void run() {
                    ThreadPool.this.timeStamp = ThreadPoolWatchdog.getCurrentNum();
                }
            });
        } else if (this.pool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.pool;
            threadPoolExecutor.execute(new Thread(){

                @Override
                public void run() {
                    ThreadPool.this.timeStamp = ThreadPoolWatchdog.getCurrentNum();
                }
            });
        }
    }

    public int getTimeStamp() {
        if (this.timeStamp == 0) {
            this.timeStamp = ThreadPoolWatchdog.getCurrentNum();
        }
        return this.timeStamp;
    }

    private void logStacks(List<ThreadInfo> threadList) {
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo threadInfo : threadList) {
            sb.append(Util.toString(threadInfo));
            sb.append("blockTime: " + threadInfo.getBlockedTime());
            sb.append('\n');
            sb.append("waitTime: " + threadInfo.getWaitedTime());
            sb.append('\n');
        }
        log.error((Object)sb.toString());
    }
}

