/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketWriter;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketWriterDispatcher
implements Runnable {
    private static Log log = LogFactory.getLog(SocketWriterDispatcher.class);
    private final Object mutex = new Object();
    private final Object mapLock = new Object();
    private Boolean running = false;
    private Thread selectThread;
    private QueuedThreadPool writeThreadPool;
    private LinkedBlockingQueue<SocketConnection> connections = new LinkedBlockingQueue();
    private static SocketWriterDispatcher instance;
    public Map<SocketConnection, QueuedThreadPool> map = new ConcurrentHashMap<SocketConnection, QueuedThreadPool>();

    public static SocketWriterDispatcher getInstance() {
        if (instance == null) {
            instance = new SocketWriterDispatcher();
        }
        return instance;
    }

    private SocketWriterDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running.booleanValue()) {
                return;
            }
            this.running = true;
            if (this.writeThreadPool == null) {
                this.writeThreadPool = ThreadPoolManager.getInstance().getWriteThreadPool();
            }
            this.selectThread = new Thread((Runnable)this, "writer_dispatcher");
            this.selectThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.running = false;
            if (this.writeThreadPool != null) {
                this.writeThreadPool.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regisgerConnection(SocketConnection connection) throws InterruptedException {
        Object object = this.mapLock;
        synchronized (object) {
            if (!this.map.containsKey(connection)) {
                this.map.put(connection, ThreadPoolManager.getInstance().getOneWriteThreadPool(connection.getRemoteAddress() + ":" + connection.getRemotePort()));
            }
        }
        this.connections.put(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedThreadPool(SocketConnection connection) {
        QueuedThreadPool queuedThreadPool = null;
        Object object = this.mapLock;
        synchronized (object) {
            queuedThreadPool = this.map.get(connection);
            if (null != queuedThreadPool) {
                this.map.remove(connection);
            }
        }
        if (queuedThreadPool != null) {
            queuedThreadPool.stop();
        }
    }

    @Override
    public void run() {
        while (this.running.booleanValue()) {
            try {
                SocketConnection connection = this.connections.take();
                this.map.get(connection).dispatch(new SocketWriter(connection));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }
}

