/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.BinHelper;
import com.swimap.base.rpc.BinTranslator;
import com.swimap.base.rpc.Compress;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.RpcSocketProtocolTCP;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketWriter
implements Runnable {
    private static Log log = LogFactory.getLog(SocketWriter.class);
    private SocketConnection connection;

    SocketWriter(SocketConnection connection) {
        this.connection = connection;
    }

    @Override
    public void run() {
        try {
            this.doWrite();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doWrite() throws Exception {
        queue = this.connection.getWriteQueue();
        pdu = null;
        try {
            isEmpty = false;
            v0 = isCompress = this.connection.isClientSupportCompress() != false && this.connection.getConnector().getProtocol() instanceof RpcSocketProtocolTCP != false;
            do lbl-1000:
            // 3 sources

            {
                block13: {
                    if (!isCompress) break block13;
                    rpcSocketPDUList = this.getPDUList(queue);
                    if (this.isNeedCompress(rpcSocketPDUList)) {
                        this.writePDU(this.encapCompressPDU(rpcSocketPDUList, this.connection.isUseOldProtocal()));
                    } else {
                        for (RpcSocketPDU rpcSocktPDU : rpcSocketPDUList) {
                            this.writePDU(rpcSocktPDU);
                        }
                    }
                    if (queue.isEmpty()) {
                        isEmpty = true;
                    }
                    if (!isEmpty) ** GOTO lbl-1000
                    break;
                }
                var5_7 = queue;
                synchronized (var5_7) {
                    pdu = queue.poll();
                    if (queue.isEmpty()) {
                        isEmpty = true;
                    }
                }
                this.writePDU(pdu);
            } while (!isEmpty);
        }
        catch (ClosedChannelException e) {
            SocketWriter.log.error((Object)"", (Throwable)e);
        }
        catch (Exception ioe) {
            this.connection.close(ioe);
        }
    }

    private boolean isNeedCompress(LinkedList<RpcSocketPDU> rpcSocketPDUList) {
        return true;
    }

    private boolean isLargerThanLimiter(LinkedList<RpcSocketPDU> rpcSocketPDUList) {
        int result = 0;
        for (RpcSocketPDU pdu : rpcSocketPDUList) {
            if ((result += BinHelper.getPDUSize(pdu)) <= RpcUtil.compressSize) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePDU(ISocketPDU pdu) throws IOException {
        if (pdu != null) {
            SocketConnection socketConnection = this.connection;
            synchronized (socketConnection) {
                OutputStream out = this.connection.getOutputStream();
                this.connection.getConnector().getProtocol().writePDU(this.connection, pdu);
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<RpcSocketPDU> getPDUList(LinkedList<ISocketPDU> queue) {
        ISocketPDU nextPDU = null;
        LinkedList<RpcSocketPDU> seriatePDUList = new LinkedList<RpcSocketPDU>();
        LinkedList<ISocketPDU> linkedList = queue;
        synchronized (linkedList) {
            while (!queue.isEmpty()) {
                nextPDU = queue.poll();
                seriatePDUList.add((RpcSocketPDU)nextPDU);
            }
        }
        return seriatePDUList;
    }

    private RpcSocketPDU encapCompressPDU(LinkedList<RpcSocketPDU> queue, boolean isUseOldProtocal) throws IOException {
        byte[] bytes = this.getBytes(queue, isUseOldProtocal);
        return this.compressAnd2PDU(bytes);
    }

    private byte[] getBytes(LinkedList<RpcSocketPDU> seriatePDU, boolean isUseOldProtocal) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        for (RpcSocketPDU pdu : seriatePDU) {
            byte[] pdubyte = BinTranslator.transPDU(pdu, isUseOldProtocal);
            out.write(pdubyte);
        }
        return out.toByteArray();
    }

    private RpcSocketPDU compressAnd2PDU(byte[] bytes) throws IOException {
        bytes = Compress.gzipCompress(bytes);
        RpcSocketPDU pdu = new RpcSocketPDU(8);
        RpcMessage message = new RpcMessage("request");
        message.addAttachment("COMPRESSEDBYTES", bytes);
        pdu.setMessage(message);
        return pdu;
    }
}

