/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketConnector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLContext;

public class SocketServerConnector
extends SocketConnector {
    private ServerSocketChannel serverSocketChannel;

    public SocketServerConnector(SSLContext sslContext, ISocketProtocol protocol, String host, int port, boolean restricted) {
        super(sslContext, protocol, host, port, restricted);
    }

    @Override
    public void open() throws IOException {
        this.serverSocketChannel = ServerSocketChannel.open();
        InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
        this.serverSocketChannel.socket().bind(addr);
        this.serverSocketChannel.configureBlocking(false);
        this.port = this.serverSocketChannel.socket().getLocalPort();
    }

    @Override
    SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    @Override
    int getSelectionOps() {
        return 16;
    }

    @Override
    protected boolean isServerConnector() {
        return true;
    }

    @Override
    void addConnection(SocketConnection connection) {
        super.addConnection(connection);
        Clients.add(connection);
    }

    @Override
    void removeConnection(SocketConnection connection) {
        Clients.remove(connection);
        super.removeConnection(connection);
    }
}

