/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.framework.monitor.ThreadCheckManager;
import com.swimap.base.framework.monitor.ThreadChecker;
import com.swimap.base.rpc.RpcAcceptProtect;
import com.swimap.base.rpc.RpcSocketClient;
import com.swimap.base.rpc.nio.HeartBeatObserver;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SelectorPool;
import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.base.rpc.nio.SocketClientConnector;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketReader;
import com.swimap.base.rpc.nio.SocketWriterDispatcher;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketServer
implements Runnable,
ThreadChecker {
    private static Log log = LogFactory.getLog(SocketServer.class);
    private final Object mutex = new Object();
    private List<SocketConnector> pendingConnectors = new ArrayList<SocketConnector>();
    protected Selector selector;
    protected Thread selectThread;
    protected HeartBeatObserver observer;
    protected SocketWriterDispatcher writerDispatcher;
    protected ExecutorService readThreadPool;
    protected QueuedThreadPool taskThreadPool;
    protected Boolean running = false;
    private Object runLock = new Object();
    private final Map<String, SocketClientConnector> clientConnectors = new ConcurrentHashMap<String, SocketClientConnector>();
    private List<SocketConnector> connectors = new ArrayList<SocketConnector>();
    private Map<SocketChannel, SocketConnection> pendingChannels = new ConcurrentHashMap<SocketChannel, SocketConnection>();

    public void addConnector(SocketConnector connector) throws IOException {
        connector.open();
        this.connectors.add(connector);
        connector.setServer(this);
        if (connector instanceof SocketClientConnector) {
            SocketClientConnector c = (SocketClientConnector)connector;
            this.clientConnectors.put(c.getKey(), c);
        }
        this.registerConnector(connector);
    }

    void removeConnector(SocketConnector connector) throws Exception {
        if (connector instanceof SocketClientConnector) {
            this.clientConnectors.remove(connector.getKey());
            this.connectors.remove(connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnector(SocketConnector connector) {
        Object object = this.mutex;
        synchronized (object) {
            this.pendingConnectors.add(connector);
        }
        object = this.runLock;
        synchronized (object) {
            if (this.running.booleanValue()) {
                this.selector.wakeup();
            }
        }
    }

    public SocketClientConnector getClientConnector(URI uri) {
        return this.clientConnectors.get(uri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketClientConnector[] getClientConnectors() {
        Map<String, SocketClientConnector> map = this.clientConnectors;
        synchronized (map) {
            SocketClientConnector[] array = new SocketClientConnector[this.clientConnectors.size()];
            this.clientConnectors.values().toArray(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.runLock;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.runLock;
        synchronized (object) {
            if (this.running.booleanValue()) {
                return;
            }
            try {
                this.selector = SelectorPool.get();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                throw new IllegalStateException("open selector failed");
            }
            if (this.readThreadPool == null) {
                this.readThreadPool = RpcSocketClient.threadPool != null ? RpcSocketClient.threadPool : ThreadPoolManager.getInstance().getReadThreadPool();
            }
            if (this.taskThreadPool == null) {
                this.taskThreadPool = ThreadPoolManager.getInstance().getTaskThreadPool();
            }
            if (this.writerDispatcher == null) {
                this.writerDispatcher = SocketWriterDispatcher.getInstance();
                this.writerDispatcher.start();
            }
            this.running = true;
            this.selectThread = new Thread((Runnable)this, "nio_selector");
            this.selectThread.start();
            ThreadCheckManager.getInstance().registerChecker(this);
            if (System.getProperty("imap.rpc.connectors") != null) {
                this.observer = new HeartBeatObserver();
                this.observer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.observer != null) {
            this.observer.stop();
        }
        Object object = this.runLock;
        synchronized (object) {
            if (!this.running.booleanValue()) {
                return;
            }
            if (this.readThreadPool != null) {
                this.readThreadPool.shutdown();
                this.readThreadPool = null;
            }
            if (this.taskThreadPool != null) {
                this.taskThreadPool.stop();
                this.taskThreadPool = null;
            }
            if (this.writerDispatcher != null) {
                this.writerDispatcher.stop();
                this.writerDispatcher = null;
            }
            ThreadPoolManager.getInstance().shutdowAll();
            this.running = false;
            this.selector.wakeup();
            this.selectThread.join();
            ThreadCheckManager.getInstance().unregisterChecker(this);
            this.selector.selectNow();
            this.selector.close();
            this.selector = null;
            this.clientConnectors.clear();
            for (SocketConnector connector : this.connectors) {
                connector.close();
            }
            this.connectors.clear();
        }
    }

    public void join() throws InterruptedException {
        if (this.isRunning()) {
            this.selectThread.join();
        }
    }

    @Override
    public void run() {
        while (this.running.booleanValue()) {
            try {
                Thread.currentThread().setPriority(10);
                this.doSelect();
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        log.fatal((Object)"This should never happen, thread will be terminated!");
    }

    private void doSelect() throws IOException {
        this.registerPendingConnectors();
        this.selector.select();
        Iterator<SelectionKey> keyIterator = this.selector.selectedKeys().iterator();
        SelectionKey key = null;
        while (keyIterator.hasNext()) {
            key = keyIterator.next();
            keyIterator.remove();
            if (!key.isValid()) {
                key.cancel();
                continue;
            }
            if (key.isReadable()) {
                this.readThreadPool.execute(new SocketReader(this.taskThreadPool, key));
                continue;
            }
            if (!key.isAcceptable()) continue;
            ServerSocketChannel ssc = null;
            try {
                ssc = (ServerSocketChannel)key.channel();
                SocketChannel socket = ssc.accept();
                if (socket == null) continue;
                String ipAddress = socket.socket().getInetAddress().getHostAddress().toString();
                if (RpcAcceptProtect.getInstance().enableAccept(ipAddress)) {
                    boolean result = ThreadPoolManager.getInstance().getAcceptThreadPool().dispatch(new AcceptJob(key, socket));
                    if (result) continue;
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"", (Throwable)e);
                    }
                    continue;
                }
                log.error((Object)("SocketServer accecpt refuse ip address " + ipAddress));
                try {
                    socket.close();
                }
                catch (Exception e) {
                    log.warn((Object)"", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (ssc != null) {
                    try {
                        ssc.close();
                    }
                    catch (Exception e1) {
                        log.warn((Object)"", (Throwable)e1);
                    }
                }
                log.warn((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPendingConnectors() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.registerPendingChannels();
            SelectionKey key = null;
            SocketConnection connection = null;
            for (SocketConnector connector : this.pendingConnectors) {
                try {
                    key = connector.getChannel().register(this.selector, connector.getSelectionOps());
                }
                catch (ClosedChannelException cce) {
                    log.error((Object)("registerPendingConnectors: " + connector), (Throwable)cce);
                    continue;
                }
                connection = connector.getConnection();
                if (connection != null) {
                    key.attach(connection);
                } else {
                    key.attach(connector);
                }
                log.warn((Object)("Started " + connector));
            }
            this.pendingConnectors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPendingChannels() {
        if (this.pendingChannels.size() > 0) {
            Set<SocketChannel> keys = this.pendingChannels.keySet();
            Iterator<SocketChannel> iter = keys.iterator();
            while (iter.hasNext()) {
                SocketChannel sc = iter.next();
                try {
                    SelectionKey k = sc.register(this.selector, 1);
                    k.attach(this.pendingChannels.get(sc));
                }
                catch (ClosedChannelException e) {
                    log.error((Object)"", (Throwable)e);
                }
                finally {
                    iter.remove();
                }
            }
        }
    }

    public void setSocketClientServer() {
        SocketClient.setServer(this);
    }

    public List<SocketConnector> getPendingConnectors() {
        return this.pendingConnectors;
    }

    public List<SocketConnector> getConnectors() {
        return this.connectors;
    }

    @Override
    public boolean check() {
        return this.selectThread.getState() == Thread.State.TERMINATED;
    }

    @Override
    public String getThreadName() {
        return this.selectThread.getName();
    }

    public class AcceptJob
    implements Runnable {
        SelectionKey key;
        SocketChannel socket;

        public AcceptJob(SelectionKey ky, SocketChannel socket) {
            this.key = ky;
            this.socket = socket;
        }

        @Override
        public void run() {
            block7: {
                SocketConnection connection = null;
                try {
                    this.socket.socket().setTcpNoDelay(true);
                    this.socket.configureBlocking(false);
                    SocketConnector connector = (SocketConnector)this.key.attachment();
                    connection = connector.newConnection(this.socket);
                    connection.onAccepted();
                    SocketServer.this.pendingChannels.put(this.socket, connection);
                    SocketServer.this.selector.wakeup();
                }
                catch (IOException e) {
                    log.error((Object)"", (Throwable)e);
                    if (connection != null) {
                        try {
                            connection.close(e);
                        }
                        catch (Exception e1) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                    if (this.socket == null) break block7;
                    try {
                        this.socket.close();
                    }
                    catch (IOException e1) {
                        log.error((Object)"", (Throwable)e1);
                    }
                }
            }
        }
    }
}

