/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.BinTranslator;
import com.swimap.base.rpc.Compress;
import com.swimap.base.rpc.RpcAssistPoolManager;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.RejectedHandler;
import com.swimap.base.rpc.nio.SSLSocketInputStream;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketHandler;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketReader
implements Runnable {
    private static Log log = LogFactory.getLog(SocketReader.class);
    private static ExecutorService singleThread = ThreadPoolManager.getInstance().getSingleThreadPool();
    private static ExecutorService mrbReadThread = ThreadPoolManager.getInstance().getMrbReadSingleThreadPool();
    private QueuedThreadPool taskThreadPool;
    private SelectionKey key;
    private boolean isFirst = true;
    public static final byte EVENT = 4;
    public static final byte MRBREADER = 7;
    public static final boolean enableAssistPool = RpcUtil.enableAssistPool();

    SocketReader(QueuedThreadPool taskThreadPool, SelectionKey key) {
        this.key = key;
        this.taskThreadPool = taskThreadPool;
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
    }

    @Override
    public void run() {
        try {
            this.doRead();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private boolean readSSL(SocketConnection conn) throws Exception {
        SSLSocketInputStream input;
        int retVal;
        if (conn.isSSLConnection() && this.isFirst && (retVal = (input = (SSLSocketInputStream)conn.getInputStream()).doRead()) <= 0) {
            if (retVal == -1) {
                throw new IOException("input closed");
            }
            this.key.interestOps(this.key.interestOps() | 1);
            this.key.selector().wakeup();
            return false;
        }
        return true;
    }

    private void handlePDU(SocketConnection conn) throws Exception {
        ISocketPDU pdu = conn.readPDU();
        if (pdu != null) {
            if (pdu.supportConcurrent() == 4) {
                singleThread.execute(new SocketHandler(conn, pdu));
            } else if (pdu.supportConcurrent() == 7) {
                mrbReadThread.execute(new SocketHandler(conn, pdu));
            } else if (pdu instanceof RpcSocketPDU && ((RpcSocketPDU)pdu).getType() == 8) {
                List<ISocketPDU> list = SocketReader.originalPDU2PDUList(conn, (RpcSocketPDU)pdu);
                for (ISocketPDU tempPDU : list) {
                    this.executeTask(conn, tempPDU);
                }
            } else {
                this.executeTask(conn, pdu);
            }
        }
    }

    void doRead() throws Exception {
        SocketConnection conn = (SocketConnection)this.key.attachment();
        try {
            if (!this.readSSL(conn)) {
                return;
            }
            this.handlePDU(conn);
            while (conn.hasMoreBytes()) {
                this.handlePDU(conn);
            }
            this.key.interestOps(this.key.interestOps() | 1);
            this.key.selector().wakeup();
        }
        catch (ClosedChannelException e) {
            this.key.cancel();
        }
        catch (IOException ioe) {
            log.error((Object)"", (Throwable)ioe);
            this.key.cancel();
            conn.close(ioe);
        }
    }

    public static List<ISocketPDU> originalPDU2PDUList(SocketConnection conn, RpcSocketPDU pdu) throws Exception {
        List<ISocketPDU> list = new LinkedList<ISocketPDU>();
        if (pdu.getType() == 8) {
            byte[] bytes = pdu.getMessage().getAttachment("COMPRESSEDBYTES");
            bytes = Compress.gzipDecompress(bytes);
            list = BinTranslator.readBytes2PDUList(conn, bytes);
        } else {
            list.add(pdu);
        }
        return list;
    }

    private void executeTask(SocketConnection conn, ISocketPDU pdu) {
        SocketHandler runnable = new SocketHandler(conn, pdu);
        if (enableAssistPool && RpcAssistPoolManager.getInstance().dispatch(pdu, runnable)) {
            return;
        }
        if (!this.taskThreadPool.dispatch(runnable)) {
            ThreadPoolManager.getInstance().getAssistPool().dispatch(new RejectedHandler(conn, pdu));
        }
    }
}

