/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.SelectorPool;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class SocketOutputStream
extends OutputStream {
    protected ByteBuffer byteBuffer;
    protected SocketChannel socketChannel;

    SocketOutputStream() {
    }

    SocketOutputStream(SocketChannel channel, int bufferSize) {
        this.socketChannel = channel;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.byteBuffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.flush();
        }
        this.byteBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.flush();
        }
        if (length < this.byteBuffer.remaining()) {
            this.byteBuffer.put(buf, offset, length);
        } else {
            while (length > 0) {
                int remaining = this.byteBuffer.remaining();
                int len = length < remaining ? length : remaining;
                this.byteBuffer.put(buf, offset, len);
                length -= len;
                offset += len;
                if (this.byteBuffer.hasRemaining()) continue;
                this.flush();
            }
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.byteBuffer.flip();
        Selector selector = null;
        SelectionKey key = null;
        try {
            int len = 0;
            while (this.byteBuffer.hasRemaining()) {
                len = this.socketChannel.write(this.byteBuffer);
                if (len < 0) {
                    throw new IOException("EOF");
                }
                if (len != 0) continue;
                if (selector == null) {
                    selector = SelectorPool.get();
                    key = this.socketChannel.register(selector, 4);
                }
                selector.select();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
            }
            if (selector != null) {
                try {
                    selector.selectNow();
                }
                catch (IOException iOException) {}
                SelectorPool.put(selector);
            }
        }
        this.byteBuffer.clear();
    }
}

