/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.SelectorPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SocketInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(SocketInputStream.class);
    protected SocketChannel socketChannel;
    protected int readTimeout = RpcUtil.getRPCTimeout();
    protected ByteBuffer byteBuffer;
    protected int readTry = 2;

    SocketInputStream(SocketChannel socketChannel, int bufferSize) {
        this.socketChannel = socketChannel;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.byteBuffer.flip();
    }

    SocketInputStream(SocketChannel socketChannel, int bufferSize, boolean direct) {
        this.socketChannel = socketChannel;
        this.byteBuffer = direct ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        this.byteBuffer.flip();
    }

    public void setSoTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    @Override
    public int available() {
        return this.byteBuffer.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
            if (eof <= 0) {
                return -1;
            }
        }
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
            if (eof < 0) {
                return -1;
            }
            if (eof == 0) {
                throw new IOException("readTimeout");
            }
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead() throws IOException {
        this.byteBuffer.clear();
        int count = 1;
        int byteRead = 0;
        Selector selector = null;
        SelectionKey key = null;
        try {
            while (count > 0) {
                count = this.socketChannel.read(this.byteBuffer);
                byteRead += count;
            }
            if (byteRead == 0) {
                selector = SelectorPool.get();
                if (selector == null) {
                    int n = 0;
                    return n;
                }
                key = this.socketChannel.register(selector, 1);
                if (selector.select(this.readTimeout) == 0) {
                    log.warn((Object)("read timeout. timeout=" + this.readTimeout + ", localPort=" + this.socketChannel.socket().getLocalPort() + ", remote=" + this.socketChannel.socket().getRemoteSocketAddress()));
                    int n = 0;
                    return n;
                }
                count = 1;
                while (count > 0) {
                    count = this.socketChannel.read(this.byteBuffer);
                    byteRead += count;
                }
            }
        }
        finally {
            if (key != null) {
                key.cancel();
            }
            if (selector != null) {
                try {
                    selector.selectNow();
                }
                catch (IOException ex) {}
                SelectorPool.put(selector);
            }
        }
        this.byteBuffer.flip();
        return byteRead;
    }
}

