/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.IConnector;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketServer;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketConnector
implements IConnector {
    private static Log log = LogFactory.getLog(SocketConnector.class);
    protected String host;
    protected int port;
    protected URI uri;
    protected SocketServer server;
    protected SSLContext sslcontext;
    protected ISocketProtocol protocol;
    private boolean restricted;
    private String key;
    private final List<SocketConnection> connections = new ArrayList<SocketConnection>();

    abstract SelectableChannel getChannel();

    abstract int getSelectionOps();

    public SocketConnector(SSLContext sslcontext, ISocketProtocol protocol, String host, int port, boolean restricted) {
        this.sslcontext = sslcontext;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.restricted = restricted;
        this.key = protocol.getPrefixPath() != null ? protocol + "://" + host + ':' + port + protocol.getPrefixPath() : protocol + "://" + host + ':' + port;
    }

    protected boolean isServerConnector() {
        return false;
    }

    void setServer(SocketServer server) {
        this.server = server;
    }

    public ISocketProtocol getProtocol() {
        return this.protocol;
    }

    public String getKey() {
        return this.key;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public SSLContext getSSLContext() {
        return this.sslcontext;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    SocketConnection getConnection() {
        return null;
    }

    @Override
    public URI getURI() throws Exception {
        if (this.uri != null) {
            return this.uri;
        }
        String sapHost = this.getHost();
        this.uri = new URI(this.protocol.getSchema(), null, sapHost, this.port, this.protocol.getPrefixPath(), null, null);
        return this.uri;
    }

    SocketConnection newConnection(SocketChannel socketChannel) {
        SocketConnection connection = new SocketConnection(this.sslcontext, this, socketChannel, !this.isServerConnector());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(SocketConnection connection) {
        List<SocketConnection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(SocketConnection connection) {
        List<SocketConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(connection);
        }
    }

    public Collection<SocketConnection> getConnections() {
        return this.connections;
    }

    void handleConnectionBroken(SocketConnection connection, Exception e) {
    }

    public void open() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        List<SocketConnection> list = this.connections;
        synchronized (list) {
            SocketConnection[] array = new SocketConnection[this.connections.size()];
            this.connections.toArray(array);
            for (SocketConnection connection : array) {
                connection.close(null);
            }
        }
        this.getChannel().close();
        this.server.removeConnector(this);
    }

    public String toString() {
        URI uri = null;
        try {
            uri = this.getURI();
        }
        catch (Exception e) {
            log.error((Object)("toString exception:" + this.host + ":" + this.port), (Throwable)e);
        }
        return this.getClass().getSimpleName() + ' ' + uri;
    }
}

