/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketServerConnector;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketConnectionHelper {
    private static Log log = LogFactory.getLog(SocketConnectionHelper.class);
    private static final String MEMORY_OLD_USED_PERCENT = "memory.old.used.percent";
    private static final int CACHE_MEMORY_PERCENT = 20;
    private static final int MAX_CACHE_SIZE_MEMORY_HIGH = 2000;
    private static final int MAX_CACHE_SIZE_MEMORY_LOW = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkWriteQueue(LinkedList<ISocketPDU> writeQueue) {
        LinkedList<ISocketPDU> linkedList = writeQueue;
        synchronized (linkedList) {
            Long memoryUsedPercent = Long.getLong(MEMORY_OLD_USED_PERCENT);
            if (memoryUsedPercent == null) {
                return true;
            }
            boolean isMemoryNotEnough = memoryUsedPercent != null && 100L - memoryUsedPercent < 20L;
            int maxCacheSize = isMemoryNotEnough ? 200 : 2000;
            int currentSize = writeQueue.size();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("checkWriteQueue: memoryUsedPercent=%s, maxCacheSize=%s, currentSize=%s ", memoryUsedPercent, maxCacheSize, currentSize));
            }
            if (maxCacheSize < currentSize) {
                log.error((Object)String.format("checkWriteQueue: ABNORMAL!!!, memoryUsedPercent=%s, cacheSize=%s currentSize=%s ", memoryUsedPercent, maxCacheSize, currentSize));
                return false;
            }
            return true;
        }
    }

    public static boolean isServerSide(SocketConnector connector) {
        return connector != null && connector instanceof SocketServerConnector;
    }
}

