/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.SSLSocketInputStream;
import com.swimap.base.rpc.nio.SSLSocketOutputStream;
import com.swimap.base.rpc.nio.SocketConnectionHelper;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketInputStream;
import com.swimap.base.rpc.nio.SocketOutputStream;
import com.swimap.base.rpc.nio.SocketWriterDispatcher;
import com.swimap.external.sf.ssl.CipherMapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketConnection {
    private long writePduCount = 0L;
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int WRITE_BUFFER_SIZE = 1024;
    private static Log log = LogFactory.getLog(SocketConnection.class);
    private boolean isPeerRestart = false;
    private long clientID = 0L;
    private int connectionID;
    private String remoteAddress;
    private int remotePort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SocketConnector connector;
    private SocketChannel socketChannel;
    private long lastReadTime = System.currentTimeMillis();
    protected SSLEngine sslEngine;
    private SocketWriterDispatcher dispatcher;
    private Boolean closed = false;
    private Object closeLock = new Object();
    private LinkedList<ISocketPDU> writeQueue = new LinkedList();
    private boolean isClientSupportCompress = false;
    private boolean isRpcServerSide = false;
    private boolean useOldProtocal = false;

    SocketConnection() {
    }

    SocketConnection(SSLContext sslContext, SocketConnector connector, SocketChannel socketChannel, boolean clientMode) {
        this.connector = connector;
        this.socketChannel = socketChannel;
        this.remoteAddress = socketChannel.socket().getInetAddress().getHostAddress();
        this.remotePort = socketChannel.socket().getPort();
        this.dispatcher = SocketWriterDispatcher.getInstance();
        if (sslContext != null) {
            String encryptLevel;
            this.sslEngine = sslContext.createSSLEngine(this.remoteAddress, this.remotePort);
            this.sslEngine.setUseClientMode(clientMode);
            boolean isSSLv23 = "SSLv23".equalsIgnoreCase(System.getProperty("imap.ssl.version"));
            if (!isSSLv23) {
                this.sslEngine.setEnabledProtocols(new String[]{sslContext.getProtocol()});
            }
            if ("".equals(encryptLevel = System.getProperty("imap.ssl.encryptLevel", "high"))) {
                encryptLevel = "high";
            }
            boolean isLoadDH = "true".equals(System.getProperty("imap.ssl.loadDH", "false"));
            this.sslEngine.setEnabledCipherSuites(CipherMapping.getCipherList((String)encryptLevel, (boolean)isLoadDH));
            String auth = System.getProperty("imap.ssl.authPeer");
            if ("true".equals(auth)) {
                this.sslEngine.setNeedClientAuth(true);
            }
        }
        this.isRpcServerSide = SocketConnectionHelper.isServerSide(connector);
    }

    public void setClientID(long id) {
        if (this.clientID == 0L) {
            this.clientID = id;
        }
    }

    public long getClientID() {
        return this.clientID;
    }

    void setConnectionID(int id) {
        this.connectionID = id;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public boolean isSSLConnection() {
        return this.sslEngine != null;
    }

    public boolean isPeerRestart() {
        return this.isPeerRestart;
    }

    public void setPeerRestart(boolean b) {
        this.isPeerRestart = b;
    }

    public void setSoTimeout(int timeout) {
        if (this.getInputStream() instanceof SocketInputStream) {
            ((SocketInputStream)this.getInputStream()).setSoTimeout(timeout);
        }
    }

    public SocketConnector getConnector() {
        return this.connector;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            if (this.sslEngine != null) {
                this.inputStream = new SSLSocketInputStream(this.sslEngine, this.socketChannel, 1024);
                ((SSLSocketInputStream)this.inputStream).setSSLOutputStream((SSLSocketOutputStream)this.getOutputStream());
            } else {
                this.inputStream = new SocketInputStream(this.socketChannel, 1024);
            }
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.sslEngine != null) {
                this.outputStream = new SSLSocketOutputStream(this.sslEngine, this.socketChannel, 1024);
                ((SSLSocketOutputStream)this.outputStream).setSSLInputStream((SSLSocketInputStream)this.getInputStream());
            } else {
                this.outputStream = new SocketOutputStream(this.socketChannel, 1024);
            }
        }
        return this.outputStream;
    }

    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected() && !this.socketChannel.socket().isClosed();
    }

    public boolean hasMoreBytes() throws IOException {
        return this.getInputStream().available() > 0;
    }

    public boolean isRestricted() {
        return this.connector.isRestricted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Exception e) throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed.booleanValue()) {
                return;
            }
            this.closed = true;
        }
        SocketWriterDispatcher.getInstance().removeQueuedThreadPool(this);
        this.connector.removeConnection(this);
        String msg = "Connection closed " + this + ": " + this.hashCode() + ", total = " + this.connector.getConnections().size();
        if (e != null) {
            log.warn((Object)msg, (Throwable)e);
        } else {
            log.warn((Object)msg);
        }
        this.connector.getProtocol().close(this);
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException ex) {
                    log.warn((Object)"", (Throwable)ex);
                }
            }
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (IOException ex) {
                    log.warn((Object)"", (Throwable)ex);
                }
            }
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.close();
                }
                catch (IOException ex) {
                    log.warn((Object)"", (Throwable)ex);
                }
            }
        }
        finally {
            this.writeQueue.clear();
            if (e != null) {
                this.connector.handleConnectionBroken(this, e);
            }
        }
    }

    void onConnected() throws IOException {
        if (this.connector.getProtocol().willHandleConnected()) {
            this.connector.getProtocol().handleConnected(this);
        }
    }

    void onAccepted() throws IOException {
        if (this.connector.getProtocol().willHandleAccepted()) {
            try {
                this.connector.getProtocol().handleAccepted(this);
            }
            catch (IOException e) {
                log.warn((Object)("turn down a new connection." + this.socketChannel.socket().getRemoteSocketAddress()), (Throwable)e);
                this.socketChannel.close();
                this.inputStream = null;
                this.outputStream = null;
                throw e;
            }
        }
        this.connector.addConnection(this);
        log.warn((Object)("New TCP connection accepted " + this + ", total = " + this.connector.getConnections().size()));
    }

    public void updateLastReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    public ISocketPDU readPDU() throws Exception {
        this.lastReadTime = System.currentTimeMillis();
        return this.connector.getProtocol().readPDU(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPduSize() {
        LinkedList<ISocketPDU> linkedList = this.writeQueue;
        synchronized (linkedList) {
            return this.writePduCount;
        }
    }

    private void writePDU() {
        ++this.writePduCount;
        if (this.writePduCount == Long.MAX_VALUE) {
            log.warn((Object)"total wirte pdu size is up to the max long value!");
            this.writePduCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePDU(ISocketPDU pdu) throws Exception {
        LinkedList<ISocketPDU> linkedList = this.closeLock;
        synchronized (linkedList) {
            if (this.closed.booleanValue()) {
                throw new Exception("Connection closed !");
            }
        }
        linkedList = this.writeQueue;
        synchronized (linkedList) {
            if (this.writeQueue.isEmpty()) {
                this.writeQueue.offer(pdu);
                this.writePDU();
                try {
                    this.dispatcher.regisgerConnection(this);
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                    this.writeQueue.clear();
                    throw e;
                }
            } else {
                if (pdu instanceof RpcSocketPDU && ((RpcSocketPDU)pdu).getType() == 5) {
                    this.writeQueue.addFirst(pdu);
                } else if (pdu instanceof MDPSocketPDU && ((MDPSocketPDU)pdu).getHeader().msgType == 16) {
                    this.writeQueue.addFirst(pdu);
                } else {
                    this.writeQueue.offer(pdu);
                }
                this.writePDU();
            }
        }
        if (this.isRpcServerSide && !SocketConnectionHelper.checkWriteQueue(this.writeQueue)) {
            this.writeQueue.clear();
            this.close(new Exception("write quene size is too long, size = " + this.writeQueue.size()));
        }
    }

    public void handlePDU(ISocketPDU pdu) throws Exception {
        this.getConnector().getProtocol().handlePDU(this, pdu);
    }

    public void handleError(ISocketPDU pdu, int errorCode) throws Exception {
        this.getConnector().getProtocol().handleError(this, pdu, errorCode);
    }

    public String toString() {
        URI uri = null;
        try {
            uri = this.connector.getURI();
            return uri + " [" + this.socketChannel.socket().getRemoteSocketAddress() + ']' + " connectionID=" + this.connectionID;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public LinkedList<ISocketPDU> getWriteQueue() {
        return this.writeQueue;
    }

    public void setClientSupportCompress(boolean isClientSupportCompress) {
        this.isClientSupportCompress = isClientSupportCompress;
    }

    boolean isClientSupportCompress() {
        return this.isClientSupportCompress;
    }

    public boolean isRpcServerSide() {
        return this.isRpcServerSide;
    }

    public boolean isUseOldProtocal() {
        return this.useOldProtocal;
    }

    public void setUseOldProtocal(boolean useOldProtocal) {
        this.useOldProtocal = useOldProtocal;
    }
}

