/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.RpcSocketProtocolTCP;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketConnector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Random;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketClientConnector
extends SocketConnector {
    private static Log log = LogFactory.getLog(SocketClientConnector.class);
    private static final long DEFAULT_CONNECT_TIMEOUT = RpcUtil.getRPCTimeout();
    private static final int RECONNECT_TIME = 200;
    private static final String LOCAL_CONNECT_IP = "USED_LOCAL_IP_ENV";
    private static final long DEFAULT_TIMEOUT_TIME = Long.MAX_VALUE;
    private static final String key = "RPC_RECONNECT_TIME";
    private static boolean rpcSocketClient = false;
    private boolean autoReconnect = true;
    private int reconnectCount = 0;
    private final Object mutex = new Object();
    private SocketConnection connection;
    private volatile ReconnectThread reconnectThread;
    private SocketClient client;

    public static boolean isRpcSocketClient() {
        return rpcSocketClient;
    }

    private static long getTimeOutTime() {
        String reconnectTime = System.getProperty(key);
        if (reconnectTime != null) {
            try {
                return Long.parseLong(reconnectTime);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return Long.MAX_VALUE;
    }

    public SocketClientConnector(SSLContext sslcontext, ISocketProtocol protocol, String host, int port, boolean restricted) {
        super(sslcontext, protocol, host, port, restricted);
    }

    void setAutoReconnect(boolean b) {
        this.autoReconnect = b;
    }

    void setReconnectCount(int count) {
        this.reconnectCount = count;
    }

    boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long timeout) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.tryToConnect();
            SocketChannel socket = SocketChannel.open();
            socket.configureBlocking(false);
            socket.socket().setTcpNoDelay(true);
            if (this.getProtocol() instanceof RpcSocketProtocolTCP) {
                rpcSocketClient = true;
                String localIp = System.getProperty(LOCAL_CONNECT_IP);
                if (localIp != null && !localIp.trim().isEmpty()) {
                    log.warn((Object)("connect with localIp:" + localIp));
                    socket.socket().bind(new InetSocketAddress(localIp, 0));
                }
            }
            if (!socket.connect(new InetSocketAddress(this.host, this.port))) {
                this.waitConnectFinished(socket, timeout);
            }
            this.connection = this.newConnection(socket);
            try {
                this.connection.onConnected();
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            this.addConnection(this.connection);
            if (this.getProtocol() instanceof RpcSocketProtocolTCP) {
                System.setProperty(LOCAL_CONNECT_IP, socket.socket().getLocalAddress().getHostAddress());
            }
            log.error((Object)("connect to " + this.host + ":" + this.port + " ,using localport " + socket.socket().getLocalPort()));
        }
        if (this.server != null) {
            this.server.registerConnector(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() throws IOException {
        int times = 0;
        Socket socket = null;
        Exception lastException = null;
        times = null == Integer.getInteger("ConnectTime") ? 0 : Integer.getInteger("ConnectTime") / 200;
        for (int i = 0; i < times; ++i) {
            try {
                log.warn((Object)("Connection attempt : " + (i + 1) + "to " + this.host + ":" + this.port));
                socket = new Socket();
                socket.connect(new InetSocketAddress(this.host, this.port), 10);
                if (socket.isConnected()) {
                    socket.close();
                    break;
                }
                Thread.sleep(200L);
                continue;
            }
            catch (Exception e) {
                lastException = e;
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
            }
        }
    }

    public void connect() throws IOException {
        this.connect(DEFAULT_CONNECT_TIMEOUT);
    }

    @Override
    public void close() throws Exception {
        this.autoReconnect = false;
        if (this.reconnectThread != null) {
            this.reconnectThread.close();
            this.reconnectThread.interrupt();
            this.reconnectThread = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitConnectFinished(SocketChannel socket, long timeout) throws IOException {
        Selector selector = null;
        try {
            selector = Selector.open();
            socket.register(selector, 8);
            if (selector.select(timeout) == 0) {
                throw new SocketTimeoutException("connect timeout");
            }
            socket.finishConnect();
        }
        finally {
            if (selector != null) {
                selector.close();
            }
            if (!socket.isConnected()) {
                socket.close();
            }
        }
    }

    @Override
    void handleConnectionBroken(SocketConnection connection, Exception e) {
        if (this.client != null) {
            if (e instanceof IOException && "readTimeout".equals(((IOException)e).getMessage())) {
                this.client.nofityReadTimeout(this);
            } else {
                this.client.notifyBreak(this);
            }
        }
        if (this.autoReconnect) {
            if (null != this.reconnectThread && this.reconnectThread.isReconnecting) {
                log.warn((Object)("A reconnect thread is already reconnecting:" + this.host + ":" + this.port));
                return;
            }
            this.reconnectThread = new ReconnectThread();
            this.reconnectThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    SelectableChannel getChannel() {
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getSocketChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketConnection getConnection() {
        Object object = this.mutex;
        synchronized (object) {
            return this.connection;
        }
    }

    @Override
    int getSelectionOps() {
        return 1;
    }

    public void setClient(SocketClient client) {
        this.client = client;
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public URI getURI() throws Exception {
        if (this.uri != null) {
            return this.uri;
        }
        String sapHost = this.getConnection().getSocketChannel().socket().getInetAddress().getHostAddress();
        int port = this.getConnection().getSocketChannel().socket().getPort();
        this.uri = new URI(this.protocol.getSchema(), null, sapHost, port, this.protocol.getPrefixPath(), null, null);
        return this.uri;
    }

    class ReconnectThread
    extends Thread {
        boolean running;
        private volatile boolean isReconnecting;

        ReconnectThread() {
            super("ReconnectThread");
            this.running = true;
            this.isReconnecting = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int retry = 0;
            long start = System.currentTimeMillis();
            long current = 0L;
            long rpcReconnectOutTime = SocketClientConnector.getTimeOutTime();
            boolean notifyCountout = true;
            Random rand = new Random();
            while (this.running) {
                try {
                    current = System.currentTimeMillis();
                    if (notifyCountout && (current - start > rpcReconnectOutTime && SocketClientConnector.this.getProtocol().getSchema().startsWith("tcp") || retry > SocketClientConnector.this.reconnectCount)) {
                        notifyCountout = false;
                        if (SocketClientConnector.this.client != null) {
                            SocketClientConnector.this.client.notifyCountout(SocketClientConnector.this);
                        }
                    }
                    ++retry;
                    Object object = SocketClientConnector.this.mutex;
                    synchronized (object) {
                        SocketClientConnector.this.connect();
                        this.isReconnecting = false;
                    }
                    log.warn((Object)(SocketClientConnector.this + " reconnected."));
                    try {
                        if (!this.running) {
                            SocketClientConnector.this.close();
                            log.warn((Object)(SocketClientConnector.this + " close connection in ReconnectThread."));
                            break;
                        }
                        if (SocketClientConnector.this.client == null) break;
                        SocketClientConnector.this.client.nodifyConnectionResume(SocketClientConnector.this, SocketClientConnector.this.connection.isPeerRestart());
                    }
                    catch (Exception e) {
                        log.error((Object)"notify reconnection meet error", (Throwable)e);
                    }
                    break;
                }
                catch (Exception e) {
                    log.error((Object)"reconnection meet error", (Throwable)e);
                    try {
                        Thread.sleep(1000 * (rand.nextInt(9) + 1));
                    }
                    catch (Exception e2) {
                        log.error((Object)"", (Throwable)e2);
                    }
                }
            }
            this.isReconnecting = false;
        }

        void close() {
            this.running = false;
        }
    }
}

