/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SingleDispatcher;
import com.swimap.base.rpc.nio.SocketClientConnector;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketServer;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketClient {
    private IResumeAction resumeAction = new IResumeAction(){

        @Override
        public boolean activateSession() {
            return true;
        }
    };
    protected static final int RETRY_COUNT = 10;
    protected static final int RETRY_INTERVAL = 1000;
    private SingleDispatcher<Listener> dispatcherListener = new SingleDispatcher();
    private SingleDispatcher<ConnectionStatusListener> dispatcherConnectionStatusListener = new SingleDispatcher();
    private static Log log = LogFactory.getLog(SocketClient.class);
    private static int _mid = 0;
    protected static SocketServer server;
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final Set<ConnectionStatusListener> connectionStatuslisteners = new HashSet<ConnectionStatusListener>();
    public static ExecutorService threadPool;
    protected static ExecutorService singleThread;
    private static final Object mutex;
    private ConnectionBreakThread connectionBreakThread = null;
    private boolean isNetworkBreakThreadRunning = false;
    private long breakStartTime = 0L;
    public static long NotifyBreakTime;

    public void setResumeAction(IResumeAction action) {
        this.resumeAction = action;
    }

    void nodifyConnectionResume(SocketClientConnector connector, boolean isPeerRestart) {
        new Thread(new NotifyConnectionResumeThread(connector, isPeerRestart)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketClient() {
        Object object = mutex;
        synchronized (object) {
            if (server == null) {
                server = new SocketServer();
                server.start();
            }
        }
        this.connectionStatuslisteners.add(new ClientListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServer(SocketServer socketServer) {
        Object object = mutex;
        synchronized (object) {
            server = socketServer;
        }
    }

    static SocketServer getServer() {
        return server;
    }

    protected synchronized int newMID() {
        return ++_mid;
    }

    public boolean isConnected(String url) {
        try {
            SocketClientConnector connector = server.getClientConnector(new URI(url));
            return connector != null && connector.getConnection().isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void close(String url) {
        try {
            SocketClientConnector connector = server.getClientConnector(new URI(url));
            if (connector != null) {
                connector.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("Close failed:" + url), (Throwable)e);
        }
    }

    protected SocketClientConnector[] getClientConnectors() {
        if (server != null) {
            return server.getClientConnectors();
        }
        return new SocketClientConnector[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener != null) {
            Set<Listener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener != null) {
            Set<Listener> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
            this.dispatcherListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionStatusListener(ConnectionStatusListener listener) {
        if (listener != null) {
            Set<ConnectionStatusListener> set = this.connectionStatuslisteners;
            synchronized (set) {
                this.connectionStatuslisteners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionStatusListener(ConnectionStatusListener listener) {
        if (listener != null) {
            Set<ConnectionStatusListener> set = this.connectionStatuslisteners;
            synchronized (set) {
                this.connectionStatuslisteners.remove(listener);
            }
            this.dispatcherConnectionStatusListener.remove(listener);
        }
    }

    private void notifyConnectionStatusChange(final URI uri, final ConnectionStatus status) {
        ConnectionStatusListener[] listeners;
        for (final ConnectionStatusListener listener : listeners = this.getConnectionStatusListeners(this.connectionStatuslisteners)) {
            this.dispatcherConnectionStatusListener.dispatch(listener, new Runnable(){

                @Override
                public void run() {
                    try {
                        if (listener != null) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("statusChange start lister=%s", listener.getClass()));
                            }
                            listener.statusChange(uri, status);
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("statusChange end lister=%s", listener.getClass()));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatusListener[] getConnectionStatusListeners(Set<ConnectionStatusListener> connectionStatuslisteners) {
        ConnectionStatusListener[] listeners = new ConnectionStatusListener[]{};
        Set<ConnectionStatusListener> set = connectionStatuslisteners;
        synchronized (set) {
            listeners = new ConnectionStatusListener[connectionStatuslisteners.size()];
            connectionStatuslisteners.toArray(listeners);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBreak_0(SocketClientConnector connector, final URI uri) {
        try {
            Listener[] ls;
            Set<Listener> set = this.listeners;
            synchronized (set) {
                ls = new Listener[this.listeners.size()];
                this.listeners.toArray(ls);
            }
            for (final Listener listener : ls) {
                this.dispatcherListener.dispatch(listener, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("connectionBroken start lister=%s", listener.getClass()));
                            }
                            listener.connectionBroken(uri);
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("connectionBroken end lister=%s", listener.getClass()));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    void notifyBreak(SocketClientConnector connector) {
        try {
            URI uri = connector.getURI();
            this.notifyBreak_0(connector, uri);
            this.notifyConnectionStatusChange(uri, ConnectionStatus.BROKEN);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    void nofityReadTimeout(SocketClientConnector connector) {
        try {
            URI uri = connector.getURI();
            this.notifyBreak_0(connector, uri);
            if (this.connectionBreakThread == null) {
                this.breakStartTime = System.currentTimeMillis();
                this.isNetworkBreakThreadRunning = true;
                this.connectionBreakThread = new ConnectionBreakThread(uri);
                this.connectionBreakThread.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyResumeOld(SocketClientConnector connector) {
        try {
            Listener[] ls;
            final URI uri = connector.getURI();
            Set<Listener> set = this.listeners;
            synchronized (set) {
                ls = new Listener[this.listeners.size()];
                this.listeners.toArray(ls);
            }
            for (final Listener listener : ls) {
                this.dispatcherListener.dispatch(listener, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("connectionResumed start lister=%s", listener.getClass()));
                            }
                            listener.connectionResumed(uri);
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("connectionResumed end lister=%s", listener.getClass()));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void notifyResume(SocketClientConnector connector) {
        this.notifyResumeOld(connector);
        try {
            URI uri = connector.getURI();
            if (System.currentTimeMillis() - this.breakStartTime < NotifyBreakTime) {
                this.notifyConnectionStatusChange(uri, ConnectionStatus.RESUMEDIMMEDIATELY);
            } else {
                this.notifyConnectionStatusChange(uri, ConnectionStatus.RESUMED);
            }
            this.isNetworkBreakThreadRunning = false;
            this.connectionBreakThread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRestart(SocketClientConnector connector) {
        try {
            Listener[] ls;
            final URI uri = connector.getURI();
            Set<Listener> set = this.listeners;
            synchronized (set) {
                ls = new Listener[this.listeners.size()];
                this.listeners.toArray(ls);
            }
            for (final Listener listener : ls) {
                this.dispatcherListener.dispatch(listener, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("restartService start lister=%s", listener.getClass()));
                            }
                            listener.restartService(uri);
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("restartService end lister=%s", listener.getClass()));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                });
            }
            this.notifyConnectionStatusChange(uri, ConnectionStatus.RESTART);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCountout(SocketClientConnector connector) {
        try {
            Listener[] ls;
            final URI uri = connector.getURI();
            Set<Listener> set = this.listeners;
            synchronized (set) {
                ls = new Listener[this.listeners.size()];
                this.listeners.toArray(ls);
            }
            for (final Listener listener : ls) {
                this.dispatcherListener.dispatch(listener, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("reconnectCountout start lister=%s", listener.getClass()));
                            }
                            listener.reconnectCountout(uri);
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("reconnectCountout end lister=%s", listener.getClass()));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                });
            }
            this.notifyConnectionStatusChange(uri, ConnectionStatus.RECONNECTIONCOUNTOUT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized SocketConnection getConnection(SSLContext sslContext, ISocketProtocol protocol, URI uri, long timeout, int reconnectCount) throws Exception {
        SocketConnection conn;
        SocketClientConnector connector = server.getClientConnector(uri);
        if (connector == null) {
            connector = new SocketClientConnector(sslContext, protocol, uri.getHost(), uri.getPort(), false);
            connector.setClient(this);
            connector.setReconnectCount(reconnectCount);
            connector.connect(timeout);
            server.addConnector(connector);
        }
        if ((conn = connector.getConnection()).isConnected()) {
            return conn;
        }
        conn.close(new Exception("Connection " + conn + " is cloed and close it."));
        throw new InterruptedIOException("socket not connected.");
    }

    static {
        mutex = new Object();
        NotifyBreakTime = RpcUtil.getNotifyBreakTimeout();
    }

    private class ConnectionBreakThread
    extends Thread {
        private URI uri;

        public ConnectionBreakThread(URI uri) {
            this.uri = uri;
        }

        @Override
        public void run() {
            while (SocketClient.this.isNetworkBreakThreadRunning) {
                if (System.currentTimeMillis() - SocketClient.this.breakStartTime > NotifyBreakTime) {
                    SocketClient.this.notifyConnectionStatusChange(this.uri, ConnectionStatus.BROKEN);
                    SocketClient.this.isNetworkBreakThreadRunning = false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class NotifyConnectionResumeThread
    implements Runnable {
        private boolean isPeerRestart;
        private SocketClientConnector connector;

        public NotifyConnectionResumeThread(SocketClientConnector connector, boolean isPeerRestart) {
            this.isPeerRestart = isPeerRestart;
            this.connector = connector;
        }

        @Override
        public void run() {
            if (SocketClient.this.resumeAction != null) {
                if (SocketClient.this.resumeAction.activateSession()) {
                    if (this.isPeerRestart) {
                        SocketClient.this.notifyRestart(this.connector);
                        SocketClient.this.notifyResumeOld(this.connector);
                    } else {
                        SocketClient.this.notifyResume(this.connector);
                    }
                } else {
                    log.warn((Object)(SocketClient.class + " activateSession failed, didn't notify."));
                }
            }
        }
    }

    public static interface IResumeAction {
        public boolean activateSession();
    }

    public class ClientListener
    implements ConnectionStatusListener {
        @Override
        public void statusChange(URI uri, ConnectionStatus status) {
            log.error((Object)("client status change:" + (Object)((Object)status) + ",uri:" + uri));
        }
    }

    public static interface ConnectionStatusListener {
        public void statusChange(URI var1, ConnectionStatus var2);
    }

    public static enum ConnectionStatus {
        BROKEN,
        RESUMED,
        RESTART,
        RECONNECTIONCOUNTOUT,
        RESUMEDIMMEDIATELY;

    }

    public static interface Listener {
        public void connectionBroken(URI var1);

        public void connectionResumed(URI var1);

        public void restartService(URI var1);

        public void reconnectCountout(URI var1);
    }
}

