/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.RpcSessionClientIDPairs;
import com.swimap.base.rpc.nio.Client;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerPush {
    private static Log log = LogFactory.getLog(ServerPush.class);

    public static void push(SocketConnection conn, ISocketPDU pdu) {
        try {
            conn.writePDU(pdu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void push(Client client, ISocketPDU pdu) throws RpcServerPush.ClientNotFound {
        if (!RpcSessionClientIDPairs.hasClientID(client.getClientID())) {
            RpcServerPush.ClientNotFound notFound = new RpcServerPush.ClientNotFound("can't found matching clientID:" + client.getClientID());
            log.warn((Object)notFound);
            throw notFound;
        }
        for (SocketConnection conn : client.getConnections()) {
            ServerPush.push(conn, pdu);
        }
    }

    public static void broadcast(ISocketPDU pdu) {
        Client[] clients;
        for (Client client : clients = Clients.getClients()) {
            try {
                ServerPush.push(client, pdu);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

