/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SelectorPool {
    private static Log log = LogFactory.getLog(SelectorPool.class);
    protected static final int maxSelectors = 150;
    protected static AtomicInteger spare = new AtomicInteger(0);
    protected static ConcurrentLinkedQueue<Selector> selectors = new ConcurrentLinkedQueue();

    SelectorPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector get() throws IOException {
        if (selectors.size() >= 150) {
            log.error((Object)("Spare value is " + spare + ", current selectors is " + selectors.size()));
        }
        Selector selector = null;
        try {
            if (selectors.size() > 0) {
                selector = selectors.poll();
            }
            if (selector == null) {
                selector = Selector.open();
            } else {
                spare.decrementAndGet();
            }
        }
        catch (NoSuchElementException x) {
            selector = Selector.open();
        }
        finally {
            if (selector == null) {
                log.error((Object)"Open a select failed.");
            }
        }
        return selector;
    }

    public static final void put(Selector selector) throws IOException {
        if (spare.get() < 150) {
            spare.incrementAndGet();
            selectors.offer(selector);
        } else {
            log.error((Object)("Spare is" + spare + ", current selectors " + selectors.size() + " has meet the max limit " + 150));
            selector.close();
        }
    }
}

