/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.NioTool;
import com.swimap.base.rpc.nio.SSLSocketInputStream;
import com.swimap.base.rpc.nio.SelectorPool;
import com.swimap.base.rpc.nio.SocketOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLSocketOutputStream
extends SocketOutputStream {
    private static Log log = LogFactory.getLog(SSLSocketOutputStream.class);
    protected ByteBuffer writeBuffer;
    private final SSLEngine sslEngine;
    private boolean toInput;
    private SSLSocketInputStream sslInput = null;
    private ByteBuffer plainText;
    private final ByteBuffer[] plainTextArray = new ByteBuffer[1];

    public SSLSocketOutputStream(SSLEngine sslEngine, SocketChannel channel, int bufferSize) {
        this.socketChannel = channel;
        this.sslEngine = sslEngine;
        this.writeBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.writeBuffer.clear();
        this.plainText = ByteBuffer.allocateDirect(bufferSize);
        this.plainText.flip();
        this.byteBuffer = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize() + 1000);
        this.byteBuffer.flip();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.writeBuffer.hasRemaining()) {
            this.flush();
        }
        this.writeBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (!this.writeBuffer.hasRemaining()) {
            this.flush();
        }
        if (length < this.writeBuffer.remaining()) {
            this.writeBuffer.put(buf, offset, length);
        } else {
            while (length > 0) {
                int remaining = this.writeBuffer.remaining();
                int len = length < remaining ? length : remaining;
                this.writeBuffer.put(buf, offset, len);
                length -= len;
                offset += len;
                if (this.writeBuffer.hasRemaining()) continue;
                this.flush();
            }
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public synchronized void enqueue(ByteBuffer writeBuff) throws IOException {
        if (this.plainText.hasRemaining() || this.byteBuffer.hasRemaining()) {
            this.plainText = SSLSocketOutputStream.append(this.plainText, writeBuff, false);
        } else {
            this.byteBuffer.compact();
            SSLEngineResult sslEngineResult = null;
            while (this.continueWrapping(sslEngineResult = this.sslEngine.wrap(writeBuff, this.byteBuffer), writeBuff)) {
            }
            this.byteBuffer.flip();
            if (writeBuff.hasRemaining()) {
                this.plainText = SSLSocketOutputStream.append(this.plainText, writeBuff, true);
            }
            this.drain();
        }
    }

    public synchronized boolean drain() throws IOException {
        do {
            if (this.byteBuffer.hasRemaining()) {
                this.writeToChannel();
            }
            if (this.byteBuffer.hasRemaining()) break;
            this.byteBuffer.compact();
            SSLEngineResult sslEngineResult = null;
            this.plainTextArray[0] = this.plainText;
            while (this.continueWrapping(sslEngineResult = this.sslEngine.wrap(this.plainText, this.byteBuffer), this.plainTextArray)) {
            }
            this.byteBuffer.flip();
        } while (this.byteBuffer.hasRemaining());
        if (this.toInput) {
            this.toInput = false;
            if (this.sslInput == null) {
                throw new IOException("sslInput is not set! Use setSSLInputQueue(...) directly after creating an SSLOutputQueue.");
            }
            this.sslInput.decrypt();
        }
        return !this.byteBuffer.hasRemaining();
    }

    private boolean continueWrapping(SSLEngineResult sslResult, ByteBuffer ... byteBuffers) {
        SSLEngineResult.Status status = sslResult.getStatus();
        switch (status) {
            case BUFFER_OVERFLOW: {
                int newValue = this.byteBuffer.capacity() + 1000;
                this.byteBuffer = NioTool.enlargeByteBuffer(this.byteBuffer, newValue);
                return true;
            }
            case OK: {
                SSLEngineResult.HandshakeStatus hsStatus = sslResult.getHandshakeStatus();
                boolean checkHandshake = true;
                block11: while (checkHandshake) {
                    switch (hsStatus) {
                        case NEED_UNWRAP: {
                            this.toInput = true;
                            return false;
                        }
                        case NEED_WRAP: {
                            return true;
                        }
                        case NEED_TASK: {
                            Runnable runnable = this.sslEngine.getDelegatedTask();
                            while (runnable != null) {
                                runnable.run();
                                runnable = this.sslEngine.getDelegatedTask();
                            }
                            hsStatus = this.sslEngine.getHandshakeStatus();
                            continue block11;
                        }
                        case FINISHED: {
                            this.toInput = true;
                        }
                    }
                    checkHandshake = false;
                }
                int length = byteBuffers.length;
                for (int i = 0; i < length; ++i) {
                    if (!byteBuffers[i].hasRemaining()) continue;
                    return true;
                }
                return false;
            }
            case CLOSED: {
                log.info((Object)"CLOSED");
            }
        }
        return false;
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer.flip();
        this.enqueue(this.writeBuffer);
        this.writeBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToChannel() throws IOException {
        Selector select = null;
        SelectionKey selectionKey = null;
        try {
            while (this.byteBuffer.hasRemaining()) {
                int length = this.socketChannel.write(this.byteBuffer);
                if (length < 0) {
                    throw new IOException("EOF");
                }
                if (length != 0) continue;
                if (select == null) {
                    select = SelectorPool.get();
                    selectionKey = this.socketChannel.register(select, 4);
                }
                select.select();
            }
        }
        finally {
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            if (select != null) {
                try {
                    select.selectNow();
                }
                catch (IOException iOException) {}
                SelectorPool.put(select);
            }
        }
    }

    public void setSSLInputStream(SSLSocketInputStream ssl) {
        this.sslInput = ssl;
    }

    protected static ByteBuffer append(ByteBuffer destination, ByteBuffer source, boolean direct) {
        int remaining = source.remaining();
        ByteBuffer returnBuffer = null;
        if (destination == null) {
            returnBuffer = direct ? ByteBuffer.allocateDirect(remaining) : ByteBuffer.allocate(remaining);
        } else {
            returnBuffer = destination;
            returnBuffer.compact();
            if (returnBuffer.remaining() < remaining) {
                int newCapacity = returnBuffer.position() + remaining;
                returnBuffer = NioTool.enlargeByteBuffer(returnBuffer, newCapacity);
            }
        }
        returnBuffer.put(source);
        returnBuffer.flip();
        return returnBuffer;
    }
}

