/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.NioTool;
import com.swimap.base.rpc.nio.SSLSocketOutputStream;
import com.swimap.base.rpc.nio.SelectorPool;
import com.swimap.base.rpc.nio.SocketInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLSocketInputStream
extends SocketInputStream {
    private static Log log = LogFactory.getLog(SSLSocketInputStream.class);
    private final SSLEngine sslEngine;
    protected ByteBuffer plainBuffer;
    private boolean toOutput;
    private boolean closed = false;
    private SSLSocketOutputStream sslOut = null;
    private int NEED_READ_MORE_DATA = -1;

    public SSLSocketInputStream(SSLEngine sslEngine, SocketChannel socketChannel, int bufferSize) {
        super(socketChannel, bufferSize, false);
        this.sslEngine = sslEngine;
        SSLSession session = sslEngine.getSession();
        int plainTextBufferSize = session.getApplicationBufferSize() + 3000;
        this.plainBuffer = ByteBuffer.allocate(plainTextBufferSize);
        this.plainBuffer.flip();
    }

    @Override
    public int available() {
        return this.plainBuffer.remaining();
    }

    public void setSSLOutputStream(SSLSocketOutputStream sslSocketOutputStream) {
        this.sslOut = sslSocketOutputStream;
    }

    @Override
    public int read() throws IOException {
        if (!this.plainBuffer.hasRemaining() && this.doRead() < 0) {
            return -1;
        }
        int retVal = this.plainBuffer.hasRemaining() ? this.plainBuffer.get() & 0xFF : -1;
        return retVal;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (!(this.plainBuffer.hasRemaining() && length <= this.plainBuffer.remaining() || this.doRead() >= 0)) {
            return -1;
        }
        if (length > this.plainBuffer.remaining()) {
            length = this.plainBuffer.remaining();
        }
        this.plainBuffer.get(b, offset, length);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readFromChannel() throws IOException {
        this.byteBuffer.compact();
        int count = 1;
        int byteRead = 0;
        Selector selector = null;
        SelectionKey key = null;
        try {
            while (count > 0) {
                if (!this.byteBuffer.hasRemaining()) {
                    this.byteBuffer = NioTool.enlargeByteBuffer(this.byteBuffer, this.byteBuffer.limit() * 2);
                }
                count = this.socketChannel.read(this.byteBuffer);
                byteRead += count;
            }
            if (byteRead == 0) {
                selector = SelectorPool.get();
                if (selector == null) {
                    int n = 0;
                    return n;
                }
                key = this.socketChannel.register(selector, 1);
                if (selector.select(this.readTimeout) == 0) {
                    log.warn((Object)("read timeout. timeout=" + this.readTimeout + ", localPort=" + this.socketChannel.socket().getLocalPort() + ", remote=" + this.socketChannel.socket().getRemoteSocketAddress()));
                    int n = 0;
                    return n;
                }
                count = 1;
                while (count > 0) {
                    if (!this.byteBuffer.hasRemaining()) {
                        this.byteBuffer = NioTool.enlargeByteBuffer(this.byteBuffer, this.byteBuffer.limit() * 2);
                    }
                    count = this.socketChannel.read(this.byteBuffer);
                    byteRead += count;
                }
            }
        }
        finally {
            if (key != null) {
                key.cancel();
            }
            if (selector != null) {
                try {
                    selector.selectNow();
                }
                catch (IOException ex) {}
                SelectorPool.put(selector);
            }
        }
        this.byteBuffer.flip();
        return byteRead;
    }

    int decrypt() throws SSLException, IOException {
        int beforeUnwrap = this.plainBuffer.remaining();
        SSLEngineResult sslEngineResult = null;
        this.plainBuffer.compact();
        while (this.continueUnwrapping(sslEngineResult = this.sslEngine.unwrap(this.byteBuffer, this.plainBuffer), this.byteBuffer)) {
        }
        this.plainBuffer.flip();
        int afterUnwrap = this.plainBuffer.remaining();
        int producedPlainText = afterUnwrap - beforeUnwrap;
        if (producedPlainText == 0 && sslEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Need read more data from socket and then unwrap them ");
            }
            return this.NEED_READ_MORE_DATA;
        }
        if (this.toOutput) {
            this.toOutput = false;
            if (this.sslOut == null) {
                throw new SSLException("sslOutputQueue is not set! Use setSSLOutputQueue(...) directly after creating an SSLInputQueue.");
            }
            this.sslOut.drain();
        }
        return producedPlainText;
    }

    public int doRead() throws IOException {
        int eof = 0;
        for (int i = 0; i < this.readTry && (eof = this.readFromChannel()) == 0; ++i) {
        }
        if (eof <= 0) {
            return -1;
        }
        int retVal = this.decrypt();
        if (retVal == this.NEED_READ_MORE_DATA) {
            return this.doRead();
        }
        return retVal;
    }

    private boolean continueUnwrapping(SSLEngineResult sslEngineResult, ByteBuffer inputBuffer) {
        SSLEngineResult.Status status = sslEngineResult.getStatus();
        switch (status) {
            case BUFFER_OVERFLOW: {
                int newValue = this.plainBuffer.capacity() + 1500;
                this.plainBuffer = NioTool.enlargeByteBuffer(this.plainBuffer, newValue);
                return true;
            }
            case OK: {
                SSLEngineResult.HandshakeStatus hsStatus = sslEngineResult.getHandshakeStatus();
                boolean checkHandshake = true;
                block11: while (checkHandshake) {
                    switch (hsStatus) {
                        case NEED_WRAP: {
                            this.toOutput = true;
                            return false;
                        }
                        case NEED_UNWRAP: {
                            return true;
                        }
                        case NEED_TASK: {
                            Runnable runnable = this.sslEngine.getDelegatedTask();
                            while (runnable != null) {
                                runnable.run();
                                runnable = this.sslEngine.getDelegatedTask();
                            }
                            hsStatus = this.sslEngine.getHandshakeStatus();
                            continue block11;
                        }
                        case FINISHED: {
                            this.toOutput = true;
                        }
                    }
                    checkHandshake = false;
                }
                return inputBuffer.hasRemaining();
            }
            case CLOSED: {
                this.closed = true;
                return false;
            }
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

