/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.AbstractLifeCycle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueuedThreadPool
extends AbstractLifeCycle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(QueuedThreadPool.class);
    private static int __pid;
    private boolean _daemon;
    private int _id;
    private List<Runnable> _idleThreads;
    private final Object _lock = new Object();
    private final Object _joinLock = new Object();
    private final Object _threadsLock = new Object();
    private int _maxWaitQueued = Integer.MAX_VALUE;
    private long _lastShrink;
    private int _shrinkAt = 0;
    private List<Runnable> _waitQueue;
    private int _minThreadsNum = 1;
    private String _pname = "btpool" + __pid++;
    private int _maxThreadsNum = 255;
    private int _lowThreads = 0;
    private int _priority = 5;
    private int _maxStopTimeByMs = 60000;
    private int _maxIdleTimeByMs = 60000;
    private Set<Runnable> _threads;

    public int getIdleThreads() {
        return this._idleThreads == null ? 0 : this._idleThreads.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeByMs;
    }

    public int getMaxThreads() {
        return this._maxThreadsNum;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public int getMinThreads() {
        return this._minThreadsNum;
    }

    public String getName() {
        return this._pname;
    }

    public int getThreads() {
        return this._threads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Object object = this._lock;
        synchronized (object) {
            return this._waitQueue.size();
        }
    }

    public List<Runnable> getQueue() {
        return this._waitQueue;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTimeByMs;
    }

    public void setMaxStopTimeMs(int stopTimeMs) {
        this._maxStopTimeByMs = stopTimeMs;
    }

    public int getShrinkAt() {
        return this._shrinkAt;
    }

    public void setShrinkAt(int shrinkAt) {
        this._shrinkAt = shrinkAt;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLowOnThreads() {
        Object object = this._lock;
        synchronized (object) {
            return this._waitQueue.size() > this._lowThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(10L);
        }
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreadsNum) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreadsNum = maxThreads;
    }

    public void setMaxQueued(int size) {
        this._maxWaitQueued = size;
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeByMs = maxIdleTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreadsNum)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreadsNum = minThreads;
        Object object = this._threadsLock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreadsNum) {
                this.newThread(null);
            }
        }
    }

    @Override
    protected void doStart() {
        if (this._maxThreadsNum < this._minThreadsNum || this._minThreadsNum <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet<Runnable>();
        this._idleThreads = new ArrayList<Runnable>();
        this._waitQueue = new LinkedList<Runnable>();
        for (int i = 0; i < this._minThreadsNum; ++i) {
            this.newThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolThread newThread(Runnable job) {
        Object object = this._threadsLock;
        synchronized (object) {
            PoolThread thread = new PoolThread(job);
            this._threads.add(thread);
            thread.setName(this._pname + "-" + this._id++);
            thread.start();
            return thread;
        }
    }

    public void setName(String name) {
        this._pname = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        super.doStop();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Object object = this._threadsLock;
            synchronized (object) {
                Iterator<Runnable> iter = this._threads.iterator();
                while (iter.hasNext()) {
                    ((Thread)iter.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0 || this._maxStopTimeByMs > 0 && (long)this._maxStopTimeByMs < System.currentTimeMillis() - start) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            log.warn((Object)(this._threads.size() + " threads could not be stopped"));
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable vJob) {
        if (!this.isRunning() || vJob == null) {
            return false;
        }
        PoolThread thread = null;
        Object object = this._lock;
        synchronized (object) {
            int idle = this._idleThreads.size();
            if (idle > 0) {
                thread = (PoolThread)this._idleThreads.remove(idle - 1);
            } else if (this._threads.size() < this._maxThreadsNum) {
                this.newThread(vJob);
            } else {
                if (this._waitQueue.size() > this._maxWaitQueued) {
                    log.warn((Object)(this._pname + " no more threads or queue slots are available"));
                    return false;
                }
                this._waitQueue.add(vJob);
            }
        }
        if (thread != null) {
            thread.dispatch(vJob);
        }
        return true;
    }

    public String getInformation() {
        int sizeQueue = this.getQueueSize();
        int sizeMax = this.getMaxThreads();
        int sizeMin = this.getMinThreads();
        int sizeWorkThread = this.getThreads();
        sizeWorkThread = sizeWorkThread < sizeMin ? sizeMin : sizeWorkThread;
        StringBuilder ss = new StringBuilder("QueueSize:").append(sizeQueue);
        ss.append("; Work thread:").append(sizeWorkThread);
        ss.append("; Max  thread:").append(sizeMax);
        ss.append("; Min  thread:").append(sizeMin);
        return ss.toString();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(QueuedThreadPool.this._daemon);
            this.setPriority(QueuedThreadPool.this._priority);
        }

        PoolThread(Runnable job) {
            this.setDaemon(QueuedThreadPool.this._daemon);
            this.setPriority(QueuedThreadPool.this._priority);
            this._job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                Object job = null;
                boolean idle = false;
                Object object = this;
                // MONITORENTER : object
                job = this._job;
                this._job = null;
                // MONITOREXIT : object
                while (QueuedThreadPool.this.isRunning()) {
                    long now;
                    if (job != null) {
                        Runnable todo = job;
                        job = null;
                        idle = false;
                        todo.run();
                        continue;
                    }
                    object = QueuedThreadPool.this._lock;
                    // MONITORENTER : object
                    if (QueuedThreadPool.this._waitQueue.size() > 0) {
                        job = (Runnable)QueuedThreadPool.this._waitQueue.remove(0);
                        // MONITOREXIT : object
                        continue;
                    }
                    if ((QueuedThreadPool.this._threads.size() > QueuedThreadPool.this._maxThreadsNum || QueuedThreadPool.this._idleThreads.size() > QueuedThreadPool.this._shrinkAt && QueuedThreadPool.this._threads.size() > QueuedThreadPool.this._minThreadsNum) && (now = System.currentTimeMillis()) - QueuedThreadPool.this._lastShrink > (long)QueuedThreadPool.this.getMaxIdleTimeMs()) {
                        QueuedThreadPool.this._lastShrink = now;
                        // MONITOREXIT : object
                        return;
                    }
                    if (!idle) {
                        QueuedThreadPool.this._idleThreads.add(this);
                        idle = true;
                    }
                    // MONITOREXIT : object
                    object = this;
                    // MONITORENTER : object
                    if (this._job == null) {
                        this.wait(QueuedThreadPool.this.getMaxIdleTimeMs());
                    }
                    job = this._job;
                    this._job = null;
                    // MONITOREXIT : object
                }
                return;
            }
            catch (InterruptedException e) {
                log.error((Object)"", (Throwable)e);
                return;
            }
            finally {
                Object e = QueuedThreadPool.this._threadsLock;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || job == null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }
    }
}

