/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NioTool {
    private static Log log = LogFactory.getLog(NioTool.class);
    private static String localhost;
    private static long startTime;

    public static String getLocalHost() {
        return localhost;
    }

    public static long getStartTime() {
        return startTime;
    }

    public static ByteBuffer enlargeByteBuffer(ByteBuffer oldBuffer, int newSize) {
        ByteBuffer newBuffer = oldBuffer.isDirect() ? ByteBuffer.allocateDirect(newSize) : ByteBuffer.allocate(newSize);
        oldBuffer.flip();
        newBuffer.put(oldBuffer);
        return newBuffer;
    }

    static {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            startTime = runtimeMXBean.getStartTime();
            log.warn((Object)("jvm's startTime = " + startTime));
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            localhost = "127.0.0.1";
        }
    }
}

