/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HeartBeatObserver
extends TimerTask {
    private static Log log = LogFactory.getLog(HeartBeatObserver.class);
    private Timer timer;
    private static long TIME_LIMIT = 180000L;
    private static int AUTO_UPDATE_INTERVAL = 60000;
    private static int WRITE_QUEUE_LIMIT = 200;
    private static int TASK_QUEUE_LIMIT = 1000;

    HeartBeatObserver() {
    }

    public void start() {
        this.timer = new Timer("rpc_observer");
        this.timer.schedule((TimerTask)this, AUTO_UPDATE_INTERVAL, (long)AUTO_UPDATE_INTERVAL);
    }

    @Override
    public void run() {
        try {
            ThreadPoolExecutor single;
            SocketConnection[] conns = Clients.getSocketConnections();
            long interval = 0L;
            int size = 0;
            for (SocketConnection conn : conns) {
                interval = System.currentTimeMillis() - conn.getLastReadTime();
                if (interval > TIME_LIMIT) {
                    try {
                        log.warn((Object)("clean pipeline connection " + conn));
                        conn.close(new IOException());
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
                size = conn.getWriteQueue().size();
                log.warn((Object)(conn + " | WritePduSize=" + conn.getTotalPduSize()));
                if (size <= WRITE_QUEUE_LIMIT) continue;
                log.warn((Object)("Block write size " + size + ". " + conn));
                if (size <= 2000) continue;
                try {
                    log.warn((Object)"block write size too much(>2000), will disconnection the connection.");
                    conn.close(new IOException());
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            QueuedThreadPool pool = ThreadPoolManager.getInstance().getTaskThreadPool();
            size = pool.getQueueSize();
            if (size > TASK_QUEUE_LIMIT) {
                log.warn((Object)("Task Block size " + size));
            }
            if ((size = (single = ThreadPoolManager.getInstance().getSingleThreadPool()).getQueue().size()) > TASK_QUEUE_LIMIT) {
                log.warn((Object)("Event Thread Pool Block queue size " + size));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Heartbeat timer have problem.", (Throwable)e);
        }
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }
}

