/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.nio;

import com.swimap.base.rpc.nio.Client;
import com.swimap.base.rpc.nio.SocketConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Clients {
    private static Log log = LogFactory.getLog(Clients.class);
    private static Integer connectionID = 0;
    private static final Map<Integer, SocketConnection> connections = new ConcurrentHashMap<Integer, SocketConnection>();
    private static final Map<Long, Client> clients = new ConcurrentHashMap<Long, Client>();
    private static final List<Listener> listeners = new ArrayList<Listener>();

    static synchronized Integer newConnectionID() {
        connectionID = connectionID + 1;
        return connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(SocketConnection conn) {
        Integer connectionID = Clients.newConnectionID();
        conn.setConnectionID(connectionID);
        Map<Long, Client> map = clients;
        synchronized (map) {
            long clientID = conn.getClientID();
            Client client = clients.get(clientID);
            if (client == null && clientID != 0L) {
                client = new Client(conn.getClientID());
                clients.put(conn.getClientID(), client);
                client.setConnectionNumber(clients.size());
            }
            if (clientID != 0L) {
                client.addConnection(conn);
            }
            connections.put(conn.getConnectionID(), conn);
        }
        Clients.notify(connectionID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClientID(SocketConnection conn) {
        Map<Long, Client> map = clients;
        synchronized (map) {
            SocketConnection[] connections;
            Client client = clients.get(conn.getClientID());
            if (client == null) {
                client = new Client(conn.getClientID());
                clients.put(conn.getClientID(), client);
            }
            if ((connections = client.getConnections()).length >= 3) {
                log.warn((Object)("same clientID comes id=" + conn.getClientID()));
                Clients.closeConnection(conn);
            } else {
                client.addConnection(conn);
            }
        }
    }

    private static void closeConnection(SocketConnection connection) {
        try {
            connection.close(null);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notify(int connectionID, boolean connected) {
        List<Listener> list = listeners;
        synchronized (list) {
            for (Listener listener : listeners) {
                if (connected) {
                    listener.clientConnected(connectionID);
                    continue;
                }
                listener.clientClosed(connectionID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(SocketConnection conn) {
        Client client;
        Map<Long, Client> map = clients;
        synchronized (map) {
            client = clients.get(conn.getClientID());
            if (client != null) {
                client.removeConnection(conn);
                if (client.isEmpty()) {
                    clients.remove(conn.getClientID());
                }
            }
            connections.remove(conn.getConnectionID());
        }
        if (client != null) {
            Clients.notify(conn.getConnectionID(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketConnection getSocketConnection(int connectionID) {
        Map<Integer, SocketConnection> map = connections;
        synchronized (map) {
            return connections.get(connectionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketConnection[] getSocketConnections() {
        Map<Integer, SocketConnection> map = connections;
        synchronized (map) {
            SocketConnection[] array = new SocketConnection[connections.size()];
            connections.values().toArray(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnected(Long clientID) {
        Map<Long, Client> map = clients;
        synchronized (map) {
            return clients.containsKey(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client getClient(long clientID) {
        Map<Long, Client> map = clients;
        synchronized (map) {
            return clients.get(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client[] getClients() {
        Map<Long, Client> map = clients;
        synchronized (map) {
            Client[] array = new Client[clients.size()];
            clients.values().toArray(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Long[] getClientIDs() {
        Map<Long, Client> map = clients;
        synchronized (map) {
            Long[] array = new Long[clients.size()];
            clients.keySet().toArray(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getClientCount() {
        Map<Long, Client> map = clients;
        synchronized (map) {
            return clients.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        List<Listener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        List<Listener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    public static interface Listener {
        public void clientConnected(int var1);

        public void clientClosed(int var1);
    }
}

