/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.msg;

import com.swimap.base.rpc.mdp.MDP;
import com.swimap.base.rpc.mrb.MRBServiceManager;
import com.swimap.base.rpc.msg.IMSGListener;
import com.swimap.external.dsf.base.rpc.mdp.IAsyncHandler;
import javax.net.ssl.SSLContext;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruEncoder;
import net.commustru.fstru.FStruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MSG {
    private static Log log = LogFactory.getLog(MSG.class);
    private MDP mdp;
    private static MSG instance;
    private boolean registerService = false;

    MSG(MDP mdp) {
        this.mdp = mdp;
    }

    public static MSG createInstance(String url) throws Exception {
        MDP mdp = MDP.createInstance(url);
        return new MSG(mdp);
    }

    public static MSG createInstance(String url, SSLContext sslContext) throws Exception {
        MDP mdp = MDP.createInstance(url, sslContext);
        return new MSG(mdp);
    }

    public static void setDefault(MSG msg) {
        instance = msg;
    }

    public static MSG getDefault() {
        return instance;
    }

    public void tryConnect(int timeout) throws Exception {
        this.mdp.tryConnect(timeout);
    }

    public void setTimeout(int timeout) {
        this.mdp.setTimeout(timeout);
    }

    public int getTimeout() {
        return this.mdp.getTimeout();
    }

    public String getURL() {
        return this.mdp.getURL();
    }

    public byte[] invoke(int pid, int mid, int cmdCode, FStruct data) throws Exception {
        if (data != null) {
            FStruEncoder enc = new FStruEncoder();
            data.serialize((Encoder)enc);
            enc.finish();
            return this.mdp.invoke(pid, mid, cmdCode, enc.toByteArray());
        }
        return this.mdp.invoke(pid, mid, cmdCode, new byte[0]);
    }

    public char asyncInvoke(IAsyncHandler handler, int pid, int mid, int cmdCode, FStruct data) throws Exception {
        if (data != null) {
            FStruEncoder enc = new FStruEncoder();
            data.serialize((Encoder)enc);
            enc.finish();
            return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, enc.toByteArray());
        }
        return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, new byte[0]);
    }

    public char asyncInvoke(IAsyncHandler handler, int pid, int mid, int cmdCode, FStruct data, int timeout) throws Exception {
        if (data != null) {
            FStruEncoder enc = new FStruEncoder();
            data.serialize((Encoder)enc);
            enc.finish();
            return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, enc.toByteArray(), timeout);
        }
        return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, new byte[0], timeout);
    }

    public void registerMSGListener(int cmdCode, IMSGListener msgListener) {
        try {
            MRBServiceManager.instance().registerMSGListener(this.mdp, cmdCode, msgListener, this.registerService);
            this.registerService = true;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void unRegisterMSGListener(int cmdCode, IMSGListener msgListener) {
        MRBServiceManager.instance().unRegisterMSGListener(cmdCode, msgListener);
    }

    public void close() {
        this.mdp.close();
        this.mdp = null;
    }
}

