/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.mdp;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.rpc.Compress;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.mdp.MDPPendingRequest;
import com.swimap.base.rpc.mdp.MDPRegister;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.base.rpc.mdp.ServiceManager;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.mdp.MessageHeader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketProtocolMDP
implements ISocketProtocol {
    private static Log log = LogFactory.getLog(SocketProtocolMDP.class);
    private static final Object lock = new Object();
    private static final String MDP = "mdp";
    private static final String MDPS = "mdps";
    private static final int SAHKE_HAND_INTERVAL = 30000;
    private static final char DEFAULT_LOCAL_PID = '\u270f';
    private static final char MDP_DESKTOP_ID = '\u0000';
    private static Timer timer = new Timer();
    private boolean isSSL = false;
    private Map<Character, MDPPendingRequest> pendingRequests = new ConcurrentHashMap<Character, MDPPendingRequest>();
    private MDPRegister register;
    private char localPID;
    private TimerTask shakeHandTask;
    private SocketChannel socketChannel;
    private OutputStream outputStream;
    private Map<String, MDPName> naming = new ConcurrentHashMap<String, MDPName>();
    private SocketConnection connection;
    private long lastReadTime = System.currentTimeMillis();
    private static final String MDP_NAMING_KEY = "MDP naming";

    SocketProtocolMDP(boolean isSSL) {
        this.isSSL = isSSL;
        this.localPID = this.getProcID();
    }

    SocketProtocolMDP(URI uri, boolean isSSL) {
        try {
            this.isSSL = isSSL;
            this.localPID = this.parsePID(uri.getPath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid MDP connector, local PID not found: " + uri);
        }
    }

    private char getProcID() {
        try {
            String procID = System.getProperty("procID");
            return (char)Integer.parseInt(procID);
        }
        catch (Exception e) {
            return '\u270f';
        }
    }

    char parsePID(String path) {
        int end = path.indexOf(47, 1);
        if (end == -1) {
            end = path.length();
        }
        return (char)Integer.parseInt(path.substring(1, end));
    }

    void setCdrRequestReceiver(String path, MessageHeader header) {
        if (path == null || path.length() == 0) {
            return;
        }
        header.receiverProcID = '\u0000';
        header.receiverModule = 0;
        header.cmdCode = 0;
        String[] ids = path.split("/");
        try {
            header.receiverProcID = (char)Integer.parseInt(ids[1]);
        }
        catch (NumberFormatException e) {
            MDPName name = this.getNaming(ids[1]);
            if (name != null) {
                header.receiverProcID = name.pid;
                header.receiverModule = name.mid;
                header.receiverProcHandle = name.handleId;
            }
            header.cmdCode = Integer.parseInt(ids[2]);
            return;
        }
        header.receiverModule = (byte)Integer.parseInt(ids[2]);
        header.cmdCode = Integer.parseInt(ids[3]);
    }

    private String headerToPath(MessageHeader header) {
        return "/" + header.receiverProcID + "/" + header.receiverModule + "/" + header.cmdCode;
    }

    @Override
    public String getSchema() {
        if (this.isSSL) {
            return MDPS;
        }
        return MDP;
    }

    @Override
    public String getPrefixPath() {
        return '/' + String.valueOf((int)this.localPID);
    }

    @Override
    public boolean willHandleConnected() {
        return true;
    }

    @Override
    public synchronized void handleConnected(SocketConnection conn) throws IOException {
        try {
            if (this.register == null) {
                this.register = new MDPRegister(conn.getSocketChannel(), conn.getInputStream(), conn.getOutputStream(), '\u0000', this.localPID);
            }
            this.register.doRegister();
            this.socketChannel = conn.getSocketChannel();
            this.outputStream = conn.getOutputStream();
            this.connection = conn;
            this.lastReadTime = System.currentTimeMillis();
            this.shakeHandTask = new ShakeHandTask();
            timer.schedule(this.shakeHandTask, 30000L, 30000L);
        }
        catch (Exception e) {
            this.register = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNamingRequest(SocketChannel socketChannel, OutputStream outputStream) throws IOException {
        MessageHeader header = new MessageHeader();
        header.msgType = (byte)10;
        log.info((Object)("send naming request,type is" + header.msgType));
        SocketConnection socketConnection = this.connection;
        synchronized (socketConnection) {
            header.writeTo(new DataOutputStream(outputStream));
            outputStream.flush();
        }
    }

    @Override
    public void close(SocketConnection conn) {
        for (MDPPendingRequest request : this.pendingRequests.values()) {
            request.cancel();
        }
        this.pendingRequests.clear();
        if (this.shakeHandTask != null) {
            this.shakeHandTask.cancel();
            this.shakeHandTask = null;
        }
        this.register = null;
    }

    @Override
    public final ISocketPDU readPDU(SocketConnection conn) throws Exception {
        DataInputStream input = new DataInputStream(conn.getInputStream());
        MessageHeader header = new MessageHeader();
        header.readFrom(input);
        if (header.msgType == 7 || header.msgType == 27 || header.msgType == 6 || header.msgType == 1 || header.msgType == 21 || header.msgType == 9) {
            if (header.contentLength > this.register.getMaxMessageLength()) {
                throw new IOException("MDP content length " + header.contentLength + " larger than registered " + this.register.getMaxMessageLength());
            }
            byte[] data = new byte[header.contentLength];
            input.readFully(data);
            if (header.isCompressData()) {
                byte[] outPutData = Compress.uncompressMsgDate(data);
                data = outPutData;
            }
            MDPSocketPDU pdu = new MDPSocketPDU(this.headerToPath(header), header, data);
            return pdu;
        }
        if (header.msgType == 5) {
            this.lastReadTime = System.currentTimeMillis();
            input.skip(header.contentLength);
            return null;
        }
        if (header.msgType == 10) {
            if (header.contentLength > this.register.getMaxMessageLength()) {
                throw new IOException("MDP content length " + header.contentLength + " larger than registered " + this.register.getMaxMessageLength());
            }
            byte[] data = new byte[header.contentLength];
            input.readFully(data);
            if (header.isCompressData()) {
                byte[] outPutData = Compress.decompress(data);
                data = outPutData;
            }
            this.updateNaming(data);
            return null;
        }
        input.skip(header.contentLength);
        log.warn((Object)("MDP message ignored, type:" + header.msgType));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNaming(byte[] data) throws IOException {
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(data));
        char procID = '\u0000';
        char handleID = '\u0000';
        byte moduleID = 0;
        String serviceType = null;
        String serviceName = null;
        Map<String, MDPName> map = this.naming;
        synchronized (map) {
            this.naming.clear();
            try {
                StringBuilder strbuf = new StringBuilder();
                while (dataIn.available() > 0) {
                    procID = dataIn.readChar();
                    handleID = dataIn.readChar();
                    moduleID = (byte)dataIn.readChar();
                    short typelength = dataIn.readShort();
                    byte[] typebuf = new byte[typelength];
                    dataIn.readFully(typebuf);
                    serviceType = new String(typebuf);
                    short serviceNamelength = dataIn.readShort();
                    byte[] namebuf = new byte[serviceNamelength];
                    dataIn.readFully(namebuf);
                    serviceName = new String(namebuf);
                    this.naming.put(serviceName, new MDPName(procID, handleID, moduleID, serviceType));
                    strbuf.append("pid = ").append((int)procID).append(", mid = ").append(moduleID).append(", handleID = ").append((int)handleID).append(", servicename = ").append(serviceName).append(", servicetype = ").append(serviceType).append("\n");
                }
                this.addSysdService();
                log.warn((Object)("naming:" + strbuf.toString()));
            }
            finally {
                this.addService();
                this.naming.notifyAll();
            }
        }
    }

    private void addSysdService() {
        char sysdProcID = 'A';
        byte sysdModuleID = -9;
        char sysdHandleID = '\u0001';
        this.naming.put("SystemAgent0101", new MDPName(sysdProcID, sysdHandleID, sysdModuleID, "SystemAgent"));
    }

    private void addService() {
        Map<String, MDPName> tmpNaming = SocketProtocolMDP.getService();
        for (Map.Entry<String, MDPName> entry : tmpNaming.entrySet()) {
            this.naming.put(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, MDPName> getService() {
        ConcurrentHashMap<String, MDPName> tmpNaming = new ConcurrentHashMap<String, MDPName>();
        char procID = '\u0000';
        char handleID = '\u0000';
        byte moduleID = 0;
        String serviceType = null;
        String serviceName = null;
        String mrbservices = System.getProperty("imap.ds.mrb.service");
        if (mrbservices != null) {
            String[] services = mrbservices.split(",");
            for (int i = 0; i < services.length; ++i) {
                String[] item = services[i].split(":");
                for (int j = 0; j < item.length; ++j) {
                    serviceName = item[0];
                    procID = (char)Integer.parseInt(item[1]);
                    handleID = '\u0000';
                    moduleID = (byte)Integer.parseInt(item[2]);
                    serviceType = item[3];
                    tmpNaming.put(serviceName, new MDPName(procID, handleID, moduleID, serviceType));
                }
            }
        }
        return tmpNaming;
    }

    public Map<String, MDPName> getNaming() {
        return this.naming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDPName getNaming(String serviceName) {
        int tryCount = 3;
        Map<String, MDPName> map = this.naming;
        synchronized (map) {
            while (this.naming.isEmpty() && tryCount > 0) {
                --tryCount;
                try {
                    this.sendNamingRequest(this.socketChannel, this.outputStream);
                    this.naming.wait(60000L);
                    log.info((Object)("getnaming result,the count is" + this.naming.size()));
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    log.info((Object)("Send query name resource request error on times " + tryCount));
                }
                catch (Exception e) {
                    log.error((Object)tryCount, (Throwable)e);
                }
            }
            if (this.naming.isEmpty() && tryCount <= 0) {
                log.error((Object)"Query MDP naming failed. System must exit.");
                FrameInformationManager.getInstance().record(MDP_NAMING_KEY, "Checking whether MDP naming is standby", false);
                FrameInformationManager.printInfo();
                System.exit(-1);
            }
            return this.naming.get(serviceName);
        }
    }

    @Override
    public void handlePDU(SocketConnection conn, ISocketPDU socketPDU) throws Exception {
        MDPSocketPDU pdu = (MDPSocketPDU)socketPDU;
        MessageHeader header = pdu.getHeader();
        if (header.msgType == 7 || header.msgType == 27) {
            char mid = header.cmdHandle;
            MDPPendingRequest pendingRequest = this.pendingRequests.remove(Character.valueOf(mid));
            if (pendingRequest != null) {
                pendingRequest.setResponse(pdu);
            } else {
                log.warn((Object)("Response ignored: " + pdu + ", mid=" + mid));
            }
        } else if (header.msgType != 2) {
            if (header.msgType == 9 || header.msgType == 21) {
                ServiceManager.handleMDP(conn, pdu);
            } else if (header.msgType == 6 || header.msgType == 1) {
                if (header.hasAppendix) {
                    log.warn((Object)("Ignored MDP PDU, pdu has Appendix(token) :" + pdu));
                    return;
                }
                if (header.isAsnRequest()) {
                    ServiceManager.handleMSG(conn, pdu);
                } else if (header.isCdrRequest()) {
                    ServiceManager.handleMDP(conn, pdu);
                }
            } else {
                log.warn((Object)("Unexpected MDP message type :" + header.msgType));
                pdu = null;
                return;
            }
        }
    }

    @Override
    public void handleError(SocketConnection conn, ISocketPDU socketPDU, int errorCode) throws Exception {
        log.error((Object)"mdp error, may be queue is full");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writePDU(SocketConnection conn, ISocketPDU socketPDU) throws IOException {
        MDPSocketPDU pdu = (MDPSocketPDU)socketPDU;
        MessageHeader header = pdu.getHeader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("msgType: " + header.msgType));
        }
        header.senderProcID = this.register.getProcessID();
        header.senderDeskID = this.register.getDesktopID();
        header.senderProcHandle = this.register.getInstanceID();
        if (header.msgType == 7) {
            MessageHeader reqHeader = (MessageHeader)pdu.getAttachment();
            header.receiverProcID = reqHeader.senderProcID;
            header.receiverModule = reqHeader.senderModule;
            header.receiverDeskID = reqHeader.senderDeskID;
            header.receiverProcHandle = reqHeader.senderProcHandle;
            header.cmdCode = reqHeader.cmdCode;
            header.cmdHandle = reqHeader.senderCmdHandle;
            byte[] body = pdu.getMessage();
            header.contentLength = body.length;
            SocketChannel socketChannel = this.socketChannel;
            synchronized (socketChannel) {
                DataOutputStream output = new DataOutputStream(conn.getOutputStream());
                header.writeTo(output);
                output.write(body);
                output.flush();
            }
        }
        this.setCdrRequestReceiver(pdu.getPath(), header);
        byte[] body = pdu.getMessage();
        header.contentLength = body.length;
        char procID = header.receiverProcID;
        boolean bool = ServiceManager.isContainProcid(procID);
        if (bool) {
            header.localMrbFlag = true;
            try {
                conn.handlePDU(new MDPSocketPDU(pdu.getPath(), header, body));
            }
            catch (Exception e) {
                log.warn((Object)"handle mdp data Exception", (Throwable)e);
            }
        } else {
            SocketChannel socketChannel = this.socketChannel;
            synchronized (socketChannel) {
                OutputStream os = conn.getOutputStream();
                DataOutputStream output = new DataOutputStream(os);
                header.writeTo(output);
                output.write(body);
                os.flush();
            }
        }
    }

    public Map<Character, MDPPendingRequest> getRequsetPendings() {
        return this.pendingRequests;
    }

    @Override
    public void handleAccepted(SocketConnection conn) throws IOException {
    }

    @Override
    public boolean willHandleAccepted() {
        return false;
    }

    public String toString() {
        return this.getSchema();
    }

    class ShakeHandTask
    extends TimerTask {
        ShakeHandTask() {
        }

        @Override
        public void run() {
            try {
                if (SocketProtocolMDP.this.connection.isConnected() && System.currentTimeMillis() - SocketProtocolMDP.this.lastReadTime > RpcUtil.getMRBReadTimeOut()) {
                    SocketProtocolMDP.this.connection.close(new IOException("MDP read timeout"));
                    return;
                }
                if (SocketProtocolMDP.this.register != null) {
                    MDPSocketPDU pdu = SocketProtocolMDP.this.register.getHeartBeatPDU();
                    SocketProtocolMDP.this.connection.writePDU(pdu);
                }
            }
            catch (Exception e) {
                log.error((Object)"send MDP shake hand failed.", (Throwable)e);
                try {
                    SocketProtocolMDP.this.connection.close(new IOException("MDP shake hand failed"));
                }
                catch (Exception ee) {
                    log.error((Object)"", (Throwable)ee);
                }
            }
        }
    }

    public static class MDPName {
        char pid;
        byte mid;
        char handleId;

        MDPName(char pid, char hid, byte mid, String stp) {
            this.pid = pid;
            this.mid = mid;
            this.handleId = hid;
        }
    }
}

