/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.mdp;

import com.swimap.base.rpc.mdp.IMDPHandle;
import com.swimap.base.rpc.mdp.MDP;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.base.rpc.mdp.SocketProtocolMDP;
import com.swimap.base.rpc.msg.IMSGListener;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import com.swimap.external.dsf.base.rpc.mdp.MessageHeader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceManager {
    private static Log log = LogFactory.getLog(ServiceManager.class);
    private static int DEFAULT_TIMEOUT = 30000;
    private static Map<Integer, IMDPHandle> serviceHandlerMap = new ConcurrentHashMap<Integer, IMDPHandle>();
    private static Map<Integer, Set<IMSGListener>> msgListenerMap = new ConcurrentHashMap<Integer, Set<IMSGListener>>();
    private static QueuedThreadPool mrbTaskThreadPool = ThreadPoolManager.getInstance().getMrbServerTaskThreadPool();
    private static QueuedThreadPool msgTaskThreadPool = ThreadPoolManager.getInstance().getMSGTaskThreadPool();
    private static int DEFAULT_LOCAL_PID = 9999;

    public ServiceManager() {
        try {
            String procID = System.getProperty("procID");
            DEFAULT_LOCAL_PID = Integer.parseInt(procID);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public Map<Integer, IMDPHandle> getServiceHandlerMap() {
        return serviceHandlerMap;
    }

    public Map<Integer, Set<IMSGListener>> getMsgListenerMap() {
        return msgListenerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MDP mdp, int procid, IMDPHandle mdphandler) throws Exception {
        this.registerService(mdp, procid);
        Map<Integer, IMDPHandle> map = serviceHandlerMap;
        synchronized (map) {
            serviceHandlerMap.put(procid, mdphandler);
        }
    }

    protected synchronized void registerService(MDP mdp, int procid) throws Exception {
        String registerPath = "/" + procid;
        mdp.registerService(registerPath, DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMSGListener(MDP mdp, int cmdCode, IMSGListener msgListener, boolean registerService) throws Exception {
        if (!registerService) {
            this.registerService(mdp, DEFAULT_LOCAL_PID);
        }
        Map<Integer, Set<IMSGListener>> map = msgListenerMap;
        synchronized (map) {
            if (msgListenerMap.containsKey(cmdCode)) {
                Set<IMSGListener> msgListenerSet = msgListenerMap.get(cmdCode);
                if (!msgListenerSet.contains(msgListener)) {
                    msgListenerSet.add(msgListener);
                }
            } else {
                HashSet<IMSGListener> msgListenerSet = new HashSet<IMSGListener>();
                msgListenerSet.add(msgListener);
                msgListenerMap.put(cmdCode, msgListenerSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterMSGListener(int cmdCode, IMSGListener msgListener) {
        Map<Integer, Set<IMSGListener>> map = msgListenerMap;
        synchronized (map) {
            if (msgListenerMap.containsKey(cmdCode)) {
                Set<IMSGListener> msgListenerSet = msgListenerMap.get(cmdCode);
                msgListenerSet.remove(msgListener);
            }
        }
    }

    public void register(MDP mdp, String serviceName, IMDPHandle mdphandler) throws Exception {
        char procid = '\u0000';
        SocketProtocolMDP.MDPName name = SocketProtocolMDP.getService().get(serviceName);
        if (name == null) {
            throw new Exception("register " + serviceName + " failed, please check the imap.ds.mrb.service item in the instance cfg file.");
        }
        procid = name.pid;
        this.register(mdp, procid, mdphandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister(MDP mdp, int procid) throws Exception {
        if (procid != 0) {
            String registerPath = "/" + procid;
            mdp.unRegisterService(registerPath);
            Map<Integer, IMDPHandle> map = serviceHandlerMap;
            synchronized (map) {
                serviceHandlerMap.remove(procid);
            }
        }
    }

    public void unRegister(MDP mdp, String serviceName) throws Exception {
        char procid = '\u0000';
        SocketProtocolMDP.MDPName name = SocketProtocolMDP.getService().get(serviceName);
        if (name != null) {
            procid = name.pid;
            if (procid != '\u0000') {
                this.unRegister(mdp, procid);
            }
        } else {
            log.warn((Object)("register " + serviceName + " failed"), (Throwable)new Exception(" please check the imap.ds.mrb.service item in the instance cfg file."));
        }
    }

    static void handleMDP(SocketConnection conn, MDPSocketPDU pdu) throws Exception {
        ServiceManager serviceManager = new ServiceManager();
        serviceManager.getClass();
        if (!mrbTaskThreadPool.dispatch(serviceManager.new MDPSocketHandler(conn, pdu))) {
            log.error((Object)"em error, may be queue is full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleMSG(SocketConnection conn, MDPSocketPDU pdu) throws Exception {
        Set<IMSGListener> msgListenerSet;
        MessageHeader header = pdu.getHeader();
        int cmdCode = header.cmdCode;
        Map<Integer, Set<IMSGListener>> map = msgListenerMap;
        synchronized (map) {
            msgListenerSet = msgListenerMap.get(cmdCode);
        }
        if (msgListenerSet != null) {
            for (IMSGListener msgListener : msgListenerSet) {
                ServiceManager serviceManager = new ServiceManager();
                serviceManager.getClass();
                msgTaskThreadPool.dispatch(serviceManager.new MSGHandler(msgListener, pdu));
            }
        }
    }

    static boolean isContainProcid(int procid) {
        return serviceHandlerMap.containsKey(procid);
    }

    private MDPSocketPDU convertPDU(byte[] data, MessageHeader requestHeader) {
        MessageHeader header = new MessageHeader();
        header.msgType = (byte)7;
        header.senderProcID = requestHeader.receiverProcID;
        header.senderModule = requestHeader.receiverModule;
        header.senderDeskID = requestHeader.receiverDeskID;
        header.senderProcHandle = requestHeader.receiverProcHandle;
        header.receiverProcID = requestHeader.senderProcID;
        header.receiverModule = requestHeader.senderModule;
        header.receiverDeskID = requestHeader.senderDeskID;
        header.receiverProcHandle = requestHeader.senderProcHandle;
        header.cmdCode = requestHeader.cmdCode;
        header.cmdHandle = requestHeader.senderCmdHandle;
        header.errCode = requestHeader.errCode;
        header.reserved = requestHeader.reserved;
        String path = this.headerToPath(requestHeader);
        MDPSocketPDU pdu = new MDPSocketPDU(path, header, data);
        pdu.attach(requestHeader);
        return pdu;
    }

    private String headerToPath(MessageHeader header) {
        return "/" + header.senderProcID + "/" + header.senderModule + "/" + header.cmdCode;
    }

    class MSGHandler
    implements Runnable {
        private IMSGListener msgListener;
        private MDPSocketPDU mdpSocketPDU;

        MSGHandler(IMSGListener msgListener, MDPSocketPDU mdpSocketPDU) {
            this.msgListener = msgListener;
            this.mdpSocketPDU = mdpSocketPDU;
        }

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }

        public void handle() throws Exception {
            if (this.msgListener != null) {
                this.msgListener.handleMSG(this.mdpSocketPDU);
            }
        }
    }

    class MDPSocketHandler
    implements Runnable {
        private SocketConnection conn;
        private MDPSocketPDU pdu;

        MDPSocketHandler(SocketConnection conn, MDPSocketPDU pdu) {
            this.conn = conn;
            this.pdu = pdu;
        }

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() throws Exception {
            IMDPHandle mdphandle;
            MessageHeader header = this.pdu.getHeader();
            int cmdCode = 0;
            char procid = header.receiverProcID;
            byte[] inArgs = null;
            if (header.msgType == 9 || header.msgType == 21) {
                cmdCode = header.msgType;
            } else {
                cmdCode = header.cmdCode;
                if (procid == DEFAULT_LOCAL_PID) {
                    return;
                }
                inArgs = this.pdu.getMessage();
            }
            boolean localMrbFlag = header.localMrbFlag;
            Map map = serviceHandlerMap;
            synchronized (map) {
                mdphandle = (IMDPHandle)serviceHandlerMap.get(procid);
            }
            byte[] data = new byte[]{};
            if (mdphandle != null) {
                try {
                    data = mdphandle.handleMDP(cmdCode, inArgs);
                }
                catch (Exception e) {
                    header.errCode = (char)4;
                    log.error((Object)"", (Throwable)e);
                }
            } else {
                header.errCode = (char)3;
                log.warn((Object)("procid " + procid + " don't register "));
            }
            MDPSocketPDU response = ServiceManager.this.convertPDU(data, header);
            if (localMrbFlag) {
                this.conn.handlePDU(response);
            } else {
                this.conn.writePDU(response);
            }
        }
    }
}

