/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.mdp;

import com.swimap.base.rpc.Compress;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.mdp.MDPPendingRequest;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.base.rpc.mdp.SocketProtocolMDP;
import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.mdp.IAsyncHandler;
import com.swimap.external.dsf.base.rpc.mdp.MDPError;
import com.swimap.external.dsf.base.rpc.mdp.MessageHeader;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import javax.net.ssl.SSLContext;

public class MDPSocketClient
extends SocketClient {
    private static int reconnectCount = Integer.MAX_VALUE;
    private SocketProtocolMDP socketProtocol;
    private byte commFlag = 0;

    MDPSocketClient() {
    }

    public void setCommFlag(byte commFlag) {
        this.commFlag = commFlag;
    }

    public static void setReconnectCount(int count) {
        reconnectCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MDPSocketPDU sendRequest(URI uri, byte[] message, SSLContext sslContext, int timeout) throws Exception {
        SocketConnection conn = this.getConnectionMDP(uri, sslContext, timeout);
        this.socketProtocol = (SocketProtocolMDP)conn.getConnector().getProtocol();
        char cmdHandle = (char)this.newMID();
        MDPPendingRequest pending = new MDPPendingRequest(cmdHandle, this.socketProtocol.getRequsetPendings());
        try {
            boolean compressFlag;
            MessageHeader header = new MessageHeader();
            header.msgType = (byte)6;
            header.senderCmdHandle = cmdHandle;
            boolean bl = compressFlag = RpcUtil.isNeedCompress() && message.length > RpcUtil.getCompressThreshold();
            if (compressFlag) {
                header.commFlag = (byte)(this.commFlag | 8);
                byte[] outPutData = Compress.compress(message);
                message = outPutData;
            } else {
                header.commFlag = this.commFlag;
            }
            MDPSocketPDU pdu = new MDPSocketPDU(uri.getPath(), header, message);
            conn.writePDU(pdu);
            MDPSocketPDU mDPSocketPDU = pending.getResponse(timeout);
            return mDPSocketPDU;
        }
        finally {
            pending.close();
        }
    }

    MDPSocketPDU sendRequest(String url, int pid, int mid, int cmdCode, byte[] message, SSLContext sslContext, int timeout) throws Exception {
        if (!this.isSupport(url)) {
            throw new IllegalArgumentException("Unspported protocol: " + url);
        }
        URI uri = new URI(this.getUrl(url, pid, mid, cmdCode));
        return this.sendRequest(uri, message, sslContext, timeout);
    }

    MDPSocketPDU sendRequest(String url, String service, int cmdCode, byte[] message, SSLContext sslContext, int timeout) throws Exception {
        if (!this.isSupport(url)) {
            throw new IllegalArgumentException("Unspported protocol: " + url);
        }
        URI uri = new URI(this.getUrl(url, service, cmdCode));
        return this.sendRequest(uri, message, sslContext, timeout);
    }

    char sendAsyncRequest(IAsyncHandler handler, String url, int pid, int mid, int cmdCode, byte[] message, SSLContext sslContext, int timeout) {
        char cmdHandle = (char)this.newMID();
        String reqURL = this.getUrl(url, pid, mid, cmdCode);
        AsyncSender sender = new AsyncSender(handler, reqURL, cmdCode, message, cmdHandle, sslContext, timeout);
        sender.start();
        return cmdHandle;
    }

    char sendAsyncRequest(IAsyncHandler handler, String url, String service, int cmdCode, byte[] message, SSLContext sslContext, int timeout) {
        char cmdHandle = (char)this.newMID();
        String reqURL = this.getUrl(url, service, cmdCode);
        AsyncSender sender = new AsyncSender(handler, reqURL, cmdCode, message, cmdHandle, sslContext, timeout);
        sender.start();
        return cmdHandle;
    }

    SocketConnection getConnectionMDP(URI uri, SSLContext sslContext, int timeout) throws Exception {
        SocketConnection conn = null;
        SocketProtocolMDP protocol = new SocketProtocolMDP(true);
        URI tempUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), protocol.getPrefixPath(), null, null);
        try {
            conn = sslContext != null ? this.getConnection(sslContext, new SocketProtocolMDP(true), tempUri, timeout, reconnectCount) : this.getConnection(sslContext, new SocketProtocolMDP(false), tempUri, timeout, reconnectCount);
        }
        catch (SocketTimeoutException e) {
            throw MDPError.getError(2);
        }
        catch (IOException e) {
            throw e;
        }
        return conn;
    }

    SocketConnection getConnectionServerMDP(URI uri, SSLContext sslContext, int timeout) throws Exception {
        SocketConnection conn = null;
        SocketProtocolMDP protocol = new SocketProtocolMDP(uri, true);
        URI tempUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), protocol.getPrefixPath(), null, null);
        try {
            conn = sslContext != null ? this.getConnection(sslContext, new SocketProtocolMDP(tempUri, true), tempUri, timeout, reconnectCount) : this.getConnection(sslContext, new SocketProtocolMDP(tempUri, false), tempUri, timeout, reconnectCount);
        }
        catch (SocketTimeoutException e) {
            throw MDPError.getError(2);
        }
        catch (IOException e) {
            throw e;
        }
        return conn;
    }

    boolean isSupport(String url) {
        return url.startsWith("mdp");
    }

    String getUrl(String url, String service, int cmdCode) {
        return url + '/' + service + '/' + cmdCode;
    }

    String getUrl(String url, int pid, int mid, int cmdCode) {
        return url + '/' + pid + '/' + mid + '/' + cmdCode;
    }

    class AsyncSender
    extends Thread {
        IAsyncHandler handler;
        String url;
        int cmdCode;
        byte[] message;
        char cmdHandle;
        SSLContext sslContext;
        int timeout;

        AsyncSender(IAsyncHandler handler, String url, int cmdCode, byte[] message, char cmdHandle, SSLContext sslContext, int timeout) {
            this.handler = handler;
            this.url = url;
            this.cmdCode = cmdCode;
            this.message = message;
            this.cmdHandle = cmdHandle;
            this.sslContext = sslContext;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MDPPendingRequest pending = null;
            try {
                boolean compressFlag;
                if (!this.url.startsWith("mdp")) {
                    throw new MDPError("Unspported protocol: " + this.url);
                }
                URI uri = new URI(this.url);
                SocketConnection conn = MDPSocketClient.this.getConnectionMDP(uri, this.sslContext, this.timeout);
                MDPSocketClient.this.socketProtocol = (SocketProtocolMDP)conn.getConnector().getProtocol();
                pending = new MDPPendingRequest(this.cmdHandle, MDPSocketClient.this.socketProtocol.getRequsetPendings());
                MessageHeader header = new MessageHeader();
                header.msgType = (byte)6;
                boolean bl = compressFlag = RpcUtil.isNeedCompress() && this.message.length > RpcUtil.getCompressThreshold();
                if (compressFlag) {
                    header.commFlag = (byte)(MDPSocketClient.this.commFlag | 8);
                    byte[] outPutData = Compress.compress(this.message);
                    this.message = outPutData;
                } else {
                    header.commFlag = MDPSocketClient.this.commFlag;
                }
                header.senderCmdHandle = this.cmdHandle;
                MDPSocketPDU pdu = new MDPSocketPDU(uri.getPath(), header, this.message);
                conn.writePDU(pdu);
                MDPSocketPDU rsp = pending.getResponse(this.timeout);
                this.handler.handleResponse(header, rsp.getMessage());
            }
            catch (MDPError e) {
                this.handler.handleError(e, this.cmdCode, this.cmdHandle);
            }
            catch (Exception ex) {
                this.handler.handleError(new MDPError(ex), this.cmdCode, this.cmdHandle);
            }
            finally {
                if (pending != null) {
                    pending.close();
                }
            }
        }
    }
}

