/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.mdp;

import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.base.rpc.nio.SSLSocketInputStream;
import com.swimap.base.rpc.nio.SSLSocketOutputStream;
import com.swimap.external.dsf.base.rpc.mdp.MessageHeader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDPRegister {
    private static Log log = LogFactory.getLog(MDPRegister.class);
    public static final char MDP_PROCESSID = '\u0002';
    public static final int REGISTER_DATA_LEN = 15;
    private static final int MDP_MSGLEN_OFFSET = 5;
    private SocketChannel socketChannel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private char desktopID;
    private char processID;
    private char instanceID;
    private int maxMessageLength;

    public MDPRegister(SocketChannel socketChannel, InputStream inputStream, OutputStream outputStream, char desktopID, char processID) {
        this.socketChannel = socketChannel;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.desktopID = desktopID;
        this.processID = processID;
        this.instanceID = this.getProcHandle();
    }

    private char getProcHandle() {
        try {
            String procHandle = System.getProperty("procHandle");
            return (char)Integer.parseInt(procHandle);
        }
        catch (Exception e) {
            return '\u0000';
        }
    }

    public char getProcessID() {
        return this.processID;
    }

    public char getInstanceID() {
        return this.instanceID;
    }

    public char getDesktopID() {
        return this.desktopID;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegister() throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        synchronized (socketChannel) {
            DataOutputStream output = new DataOutputStream(this.outputStream);
            MessageHeader header = this.createRegisterHeader();
            header.writeTo(output);
            String senderIP = RpcUtil.convertIp2Hex();
            senderIP = senderIP + header.senderProcID;
            byte[] buf = senderIP.getBytes("ASCII");
            byte[] data = new byte[15];
            System.arraycopy(buf, 0, data, 0, buf.length);
            output.write(data);
            this.outputStream.flush();
            if (this.outputStream instanceof SSLSocketOutputStream) {
                boolean lab = true;
                while (lab) {
                    int retVal = ((SSLSocketInputStream)this.inputStream).doRead();
                    if (retVal <= 0) {
                        if (retVal != -1) continue;
                        throw new IOException("input closed");
                    }
                    lab = false;
                }
            }
            DataInputStream input = new DataInputStream(this.inputStream);
            header.readFrom(input);
            byte[] rspData = new byte[header.contentLength];
            input.readFully(rspData);
            this.instanceID = header.receiverProcHandle;
            this.desktopID = header.receiverDeskID;
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(rspData, 5, 4));
            this.maxMessageLength = di.readInt();
        }
        log.warn((Object)("MDP register OK: PID=" + this.processID + ", PHD=" + this.instanceID + ", DID=" + this.desktopID + ", MLEN=" + this.maxMessageLength));
    }

    MessageHeader createRegisterHeader() {
        MessageHeader header = new MessageHeader();
        header.senderProcID = this.processID;
        header.senderDeskID = this.desktopID;
        header.senderProcHandle = this.instanceID;
        header.receiverProcID = (char)2;
        header.receiverDeskID = '\u0000';
        header.receiverProcHandle = '\u0000';
        header.msgType = (byte)17;
        header.cmdCode = 0;
        header.contentLength = 15;
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doShakeHand() throws IOException {
        MessageHeader header = new MessageHeader();
        header.msgType = (byte)16;
        header.senderDeskID = this.desktopID;
        header.senderProcID = this.processID;
        header.senderProcHandle = this.instanceID;
        header.receiverProcID = (char)2;
        header.receiverProcHandle = '\u0000';
        header.receiverDeskID = '\u0000';
        header.cmdCode = 0;
        header.senderModule = 0;
        header.receiverModule = 0;
        header.contentLength = 0;
        SocketChannel socketChannel = this.socketChannel;
        synchronized (socketChannel) {
            DataOutputStream output = new DataOutputStream(this.outputStream);
            header.writeTo(output);
            this.outputStream.flush();
        }
    }

    public MDPSocketPDU getHeartBeatPDU() {
        MessageHeader header = new MessageHeader();
        header.msgType = (byte)16;
        header.senderDeskID = this.desktopID;
        header.senderProcID = this.processID;
        header.senderProcHandle = this.instanceID;
        header.receiverProcID = (char)2;
        header.receiverProcHandle = '\u0000';
        header.receiverDeskID = '\u0000';
        header.cmdCode = 0;
        header.senderModule = 0;
        header.receiverModule = 0;
        header.contentLength = 0;
        MDPSocketPDU pdu = new MDPSocketPDU(null, header, new byte[0]);
        return pdu;
    }
}

