/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.mdp;

import com.swimap.base.rpc.mdp.MDPSocketClient;
import com.swimap.base.rpc.mdp.MDPSocketPDU;
import com.swimap.external.dsf.base.rpc.mdp.IAsyncHandler;
import com.swimap.external.dsf.base.rpc.mdp.MDPError;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;

public class MDP {
    private static MDPSocketClient socketClient = null;
    private static MDP instance;
    private int timeout;
    private static int DEFAULT_TIMEOUT;
    private String url;
    private SSLContext sslContext;

    MDP(String url) {
        this.url = url;
        this.timeout = DEFAULT_TIMEOUT;
    }

    MDP(String url, SSLContext sslContext) {
        this.url = url;
        this.timeout = DEFAULT_TIMEOUT;
        this.sslContext = sslContext;
    }

    public static MDP createInstance(String url) throws Exception {
        new URI(url);
        MDP mdp = new MDP(url);
        return mdp;
    }

    public static MDP createInstance(String url, SSLContext sslContext) throws Exception {
        URI uri = new URI(url);
        if (!"mdps".equals(uri.getScheme())) {
            throw new URISyntaxException(uri.toString(), "url for SSL must be 'mdps'.");
        }
        if (sslContext == null) {
            throw new NullPointerException("SSLContext null");
        }
        MDP mdp = new MDP(url, sslContext);
        return mdp;
    }

    public static void setDefault(MDP mdp) {
        instance = mdp;
    }

    public static MDP getDefault() {
        return instance;
    }

    public void tryConnect(int timeout) throws Exception {
        MDP.getSocketClient().getConnectionMDP(new URI(this.url), this.sslContext, timeout);
    }

    public void registerService(String path, int timeout) throws Exception {
        URI uri = new URI(this.url + path);
        MDP.getSocketClient().getConnectionServerMDP(uri, this.sslContext, timeout);
    }

    public void unRegisterService(String path) throws Exception {
        String urlPath = this.url + path;
        MDP.getSocketClient().close(urlPath);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getURL() {
        return this.url;
    }

    public byte[] invoke(String service, int cmdCode, byte[] data) throws MDPError {
        MDPSocketPDU pdu;
        try {
            pdu = MDP.getSocketClient().sendRequest(this.url, service, cmdCode, data, this.sslContext, this.timeout);
        }
        catch (MDPError e) {
            throw e;
        }
        catch (Exception ex) {
            throw new MDPError(ex);
        }
        return pdu.getMessage();
    }

    public byte[] invoke(String service, int cmdCode, byte[] data, int timeout) throws MDPError {
        MDPSocketPDU pdu;
        try {
            pdu = MDP.getSocketClient().sendRequest(this.url, service, cmdCode, data, this.sslContext, timeout);
        }
        catch (MDPError e) {
            throw e;
        }
        catch (Exception ex) {
            throw new MDPError(ex);
        }
        return pdu.getMessage();
    }

    public char asyncInvoke(IAsyncHandler handler, String service, int cmdCode, byte[] data) {
        char cmdHandle = MDP.getSocketClient().sendAsyncRequest(handler, this.url, service, cmdCode, data, this.sslContext, this.timeout);
        return cmdHandle;
    }

    public char asyncInvoke(IAsyncHandler handler, String service, int cmdCode, byte[] data, int timeout) {
        char cmdHandle = MDP.getSocketClient().sendAsyncRequest(handler, this.url, service, cmdCode, data, this.sslContext, timeout);
        return cmdHandle;
    }

    public char asyncInvoke(IAsyncHandler handler, int pid, int mid, int cmdCode, byte[] data) {
        char cmdHandle = MDP.getSocketClient().sendAsyncRequest(handler, this.url, pid, mid, cmdCode, data, this.sslContext, this.timeout);
        return cmdHandle;
    }

    public char asyncInvoke(IAsyncHandler handler, int pid, int mid, int cmdCode, byte[] data, int timeout) {
        char cmdHandle = MDP.getSocketClient().sendAsyncRequest(handler, this.url, pid, mid, cmdCode, data, this.sslContext, timeout);
        return cmdHandle;
    }

    public byte[] invoke(int pid, int mid, int cmdCode, byte[] data) throws MDPError {
        MDPSocketPDU pdu;
        try {
            pdu = MDP.getSocketClient().sendRequest(this.url, pid, mid, cmdCode, data, this.sslContext, this.timeout);
        }
        catch (MDPError e) {
            throw e;
        }
        catch (Exception e) {
            throw new MDPError(e);
        }
        return pdu.getMessage();
    }

    public static synchronized MDPSocketClient getSocketClient() {
        if (socketClient == null) {
            socketClient = new MDPSocketClient();
        }
        return socketClient;
    }

    public void close() {
        if (socketClient != null) {
            socketClient.close(this.url);
        }
    }

    static void setSocketClient(MDPSocketClient socketClient) {
        MDP.socketClient = socketClient;
    }

    static {
        DEFAULT_TIMEOUT = 180000;
    }
}

