/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.em;

import com.swimap.base.framework.StatusInfoUtil;
import com.swimap.base.rpc.em.EMSocketClient;
import com.swimap.base.rpc.em.EMSocketPDU;
import com.swimap.base.rpc.em.IEMListener;
import com.swimap.external.dsf.base.rpc.cdr.CdrEvent;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.net.URI;
import javax.net.ssl.SSLContext;

public class EMRequest {
    public static final String SUB_EVENT_METHOD = "sub";
    public static final String UNSUB_EVENT_METHOD = "unsub";
    private static final int DEFAULT_REQUEST_TIMEOUT = 60000;
    private static EMSocketClient socketClient = null;
    private static EMRequest instance;
    private int timeout;
    private SSLContext sslContext;
    private String url;
    private IEMListener EMlistener;
    private String serviceULR;

    EMRequest(String url, IEMListener listener) {
        this.url = url;
        this.EMlistener = listener;
        this.setTimeout(60000);
    }

    EMRequest(String url, SSLContext sslContext, IEMListener listener) throws Exception {
        if (url != null && !url.startsWith("ems")) {
            throw new Exception("SSL type , must use 'ems' prefix");
        }
        if (sslContext == null) {
            throw new NullPointerException("SSL Context null");
        }
        this.url = url;
        this.EMlistener = listener;
        this.setTimeout(60000);
        this.sslContext = sslContext;
    }

    public static EMRequest create(String url, IEMListener listener) {
        return new EMRequest(url, listener);
    }

    public static EMRequest create(String url, SSLContext sslContext, IEMListener listener) throws Exception {
        return new EMRequest(url, sslContext, listener);
    }

    public static void setDefault(EMRequest request) {
        instance = request;
    }

    public static EMRequest getDefault() {
        return instance;
    }

    public String getURL() {
        return this.url;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    boolean isSupport(String url) {
        return url.startsWith("em");
    }

    public void sendEM(CdrEvent event) throws Exception {
        this.serviceULR = this.url;
        this.remoteInvoke(true, event);
    }

    public void subscribe(String eventType) throws Exception {
        this.subscribe(EventClassType.createByEventType(eventType));
    }

    public void subscribe(EventClassType eventType) throws Exception {
        this.serviceULR = this.url + '/' + SUB_EVENT_METHOD;
        this.remoteInvoke(false, new CdrEvent(eventType));
    }

    public void unSubscribe(String eventType) throws Exception {
        this.unSubscribe(EventClassType.createByEventType(eventType));
    }

    public void unSubscribe(EventClassType eventType) throws Exception {
        if (StatusInfoUtil.isFrameworkStopping()) {
            return;
        }
        this.serviceULR = this.url + '/' + UNSUB_EVENT_METHOD;
        this.remoteInvoke(false, new CdrEvent(eventType));
    }

    EMSocketPDU remoteInvoke(boolean oneway, CdrEvent event) throws Exception {
        if (this.url == null) {
            throw new Exception("'imap.rpc.em' not set, cannot use EM.");
        }
        if (this.isSupport(this.serviceULR)) {
            URI uri = new URI(this.serviceULR);
            if (oneway) {
                EMRequest.getSocketClient().sendOneway(uri, event, this.sslContext, this.EMlistener, this.timeout);
                return null;
            }
            EMSocketPDU rsp = EMRequest.getSocketClient().sendRequest(uri, event, this.sslContext, this.EMlistener, this.timeout);
            return rsp;
        }
        throw new IllegalArgumentException("Unspported protocol: " + this.url);
    }

    public static synchronized EMSocketClient getSocketClient() {
        if (socketClient == null) {
            socketClient = new EMSocketClient();
        }
        return socketClient;
    }

    public void close() {
        if (socketClient != null) {
            socketClient.close(this.url);
        }
    }

    static void setEMSocketClient(EMSocketClient socketClient) {
        EMRequest.socketClient = socketClient;
    }
}

