/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.cdr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.NameValuePair;
import org.omg.GIOP.Version;
import org.openorb.CORBA.dynany.DynAnyFactoryImpl;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;

public class CDR {
    private static Log log = LogFactory.getLog(CDR.class);
    private static Version version = new Version(1, 2);
    private static ORB orb;
    private static DynAnyFactory factory;

    static void setDynAnyFactory(DynAnyFactory mock) {
        if (mock != null) {
            factory = mock;
        }
    }

    public static ORB orb() {
        return orb;
    }

    public static Any createAny() {
        return orb.create_any();
    }

    public static byte[] encode(Streamable dataHolder) {
        MarshalBuffer buffer = new MarshalBuffer(null, null);
        CDROutputStream stream = new CDROutputStream(orb, version, buffer);
        stream.write_octet((byte)0);
        dataHolder._write((OutputStream)stream);
        return buffer.lastFragment().linearize();
    }

    public static byte[] encodeWithoutByteOrder(Streamable dataHolder) {
        MarshalBuffer buffer = new MarshalBuffer(null, null);
        CDROutputStream stream = new CDROutputStream(orb, version, buffer);
        dataHolder._write((OutputStream)stream);
        return buffer.lastFragment().linearize();
    }

    public static boolean decode(byte[] buf, Streamable dataHolder) {
        StorageBuffer buffer = new StorageBuffer(buf, 0, buf.length);
        CDRInputStream stream = new CDRInputStream(orb, true, version, buffer);
        byte byteOrder = stream.read_octet();
        boolean bigEndian = byteOrder == 0;
        stream.bigEndian(bigEndian);
        dataHolder._read((InputStream)stream);
        return bigEndian;
    }

    public static void decode(byte[] buf, Streamable dataHolder, boolean bigEndian) {
        StorageBuffer buffer = new StorageBuffer(buf, 0, buf.length);
        CDRInputStream stream = new CDRInputStream(orb, true, version, buffer);
        stream.bigEndian(bigEndian);
        dataHolder._read((InputStream)stream);
    }

    public static String anyToString(Any any, boolean verbose) {
        return CDR.printAny(any, verbose);
    }

    private static String printShort(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Throwable e) {
                id = "Short: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_short();
    }

    private static String printAny(Any a, boolean includedId) {
        String result = "";
        try {
            TypeCode typeCode = a.type();
            while (typeCode.kind() == TCKind.tk_alias) {
                typeCode = typeCode.content_type();
            }
            switch (typeCode.kind().value()) {
                case 0: {
                    result = "null";
                    break;
                }
                case 1: {
                    result = "void";
                    break;
                }
                case 2: {
                    result = CDR.printShort(a, result, includedId);
                    break;
                }
                case 3: {
                    result = CDR.printLong(a, result, includedId);
                    break;
                }
                case 4: {
                    result = CDR.printUShort(a, result, includedId);
                    break;
                }
                case 5: {
                    result = CDR.printULong(a, result, includedId);
                    break;
                }
                case 6: {
                    result = CDR.printFloat(a, result, includedId);
                    break;
                }
                case 7: {
                    result = CDR.printDouble(a, result, includedId);
                    break;
                }
                case 8: {
                    result = CDR.printBoolean(a, result, includedId);
                    break;
                }
                case 9: {
                    result = CDR.printChar(a, result, includedId);
                    break;
                }
                case 10: {
                    result = CDR.printOctet(a, result, includedId);
                    break;
                }
                case 11: {
                    result = CDR.printAny(a.extract_any(), includedId);
                    break;
                }
                case 12: {
                    result = CDR.printTypeCode(a, result, includedId);
                    break;
                }
                case 13: {
                    result = CDR.printPrincipal(a, result, includedId);
                    break;
                }
                case 14: {
                    result = CDR.printObjref(a, result, includedId);
                    break;
                }
                case 15: {
                    result = CDR.printStruct(a, result, includedId);
                    break;
                }
                case 16: {
                    result = CDR.printUnion(a, result, includedId);
                    break;
                }
                case 17: {
                    result = CDR.printEnum(a, result, includedId);
                    break;
                }
                case 18: {
                    result = CDR.printString(a, result, includedId);
                    break;
                }
                case 19: {
                    result = CDR.printSequence(a, result, includedId);
                    break;
                }
                case 20: {
                    result = CDR.printArray(a, result, includedId);
                    break;
                }
                case 21: {
                    result = "alias";
                    break;
                }
                case 22: {
                    result = CDR.printException(a, result, includedId);
                    break;
                }
                case 23: {
                    result = CDR.printLonglong(a, result, includedId);
                    break;
                }
                case 24: {
                    result = CDR.printUlonglong(a, result, includedId);
                    break;
                }
                case 25: {
                    result = CDR.printLongdouble(a, result, includedId);
                    break;
                }
                case 26: {
                    result = CDR.printWchar(a, result, includedId);
                    break;
                }
                case 27: {
                    result = CDR.printWstring(a, result, includedId);
                    break;
                }
                case 28: {
                    result = CDR.printFixed(a, result, includedId);
                    break;
                }
                case 29: {
                    result = CDR.printValue(a, result, includedId);
                    break;
                }
                case 30: {
                    result = "value_box";
                    break;
                }
                case 31: {
                    result = "native";
                    break;
                }
                case 32: {
                    result = "abstract_interface";
                    break;
                }
                default: {
                    result = "<null,kind=" + a.type().kind().value() + '>';
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((java.lang.Object)"Exception ", (Throwable)e);
            return result;
        }
    }

    private static String printUShort(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "UShort: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_ushort();
    }

    private static String printLong(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Throwable e) {
                id = "Long: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_long();
    }

    private static String printULong(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "ULong: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_ulong();
    }

    private static String printDouble(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Double: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_double();
    }

    private static String printFloat(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Float: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_float();
    }

    private static String printBoolean(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Boolean: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_boolean();
    }

    private static String printChar(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Char: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_char();
    }

    private static String printOctet(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Octet: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_octet();
    }

    private static String printTypeCode(Any any, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "TypeCode: ";
            }
        } else {
            id = "";
        }
        return ret + id + any.create_input_stream().read_TypeCode();
    }

    private static String printUnion(Any a, String ret, boolean includedId) throws Exception {
        String id;
        StringBuffer strBuffer = new StringBuffer();
        try {
            id = a.type().id();
        }
        catch (Exception e) {
            id = "Union";
        }
        strBuffer.append(ret + id + " ( ");
        DynUnion dynunion = (DynUnion)factory.create_dyn_any(a);
        if (includedId) {
            strBuffer.append(dynunion.member_name() + " : ");
        }
        strBuffer.append(CDR.printAny(dynunion.member().to_any(), includedId));
        strBuffer.append(" ) ");
        return strBuffer.toString();
    }

    private static String printObjref(Any any, String ret, boolean includedId) {
        Object obj;
        String myid;
        if (includedId) {
            try {
                myid = any.type().id() + ": ";
            }
            catch (Exception e) {
                myid = "Objref: ";
            }
        } else {
            myid = "";
        }
        if ((obj = any.create_input_stream().read_Object()) != null) {
            return ret + myid + orb.object_to_string(obj);
        }
        return ret + myid + "null";
    }

    private static String printPrincipal(Any any, String ret, boolean includedId) {
        String myid;
        if (includedId) {
            try {
                myid = any.type().id() + ": ";
            }
            catch (Exception e) {
                myid = "Principal: ";
            }
        } else {
            myid = "";
        }
        return ret + myid + "Deprecated by CORBA 2.2.";
    }

    private static String printString(Any a, String ret, boolean includedId) {
        String myid;
        if (includedId) {
            try {
                myid = a.type().id() + ": ";
            }
            catch (Exception e) {
                myid = "String: ";
            }
        } else {
            myid = "";
        }
        return ret + myid + "\"" + a.create_input_stream().read_string() + "\"";
    }

    private static String printStruct(Any any, String ret, boolean includedId) throws Exception {
        String myid;
        StringBuffer strBuffer = new StringBuffer();
        DynStruct dynstruct = (DynStruct)factory.create_dyn_any(any);
        NameValuePair[] members = dynstruct.get_members();
        if (includedId) {
            try {
                myid = any.type().id();
            }
            catch (Exception e) {
                myid = "Struct";
            }
        } else {
            myid = "";
        }
        strBuffer.append(ret + myid + "{\n");
        for (int i = 0; i < members.length; ++i) {
            strBuffer.append("\t");
            if (includedId) {
                strBuffer.append(members[i].id + " : ");
            }
            strBuffer.append(CDR.printAny(members[i].value, includedId));
            if (i >= members.length - 1) continue;
            strBuffer.append(" , \n");
        }
        strBuffer.append("\n}");
        return strBuffer.toString();
    }

    private static String printEnum(Any any, String ret, boolean includedId) throws Exception {
        String id;
        DynEnum dynEnum = (DynEnum)factory.create_dyn_any(any);
        if (includedId) {
            try {
                id = any.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Enum: ";
            }
        } else {
            id = "";
        }
        return ret + id + dynEnum.get_as_string();
    }

    private static String printException(Any a, String ret, boolean includedId) throws Exception {
        String id;
        StringBuffer strBuffer = new StringBuffer();
        DynStruct dynstruct = (DynStruct)factory.create_dyn_any(a);
        NameValuePair[] members = dynstruct.get_members();
        if (includedId) {
            try {
                id = a.type().id();
            }
            catch (Exception e) {
                id = "IdlExcept";
            }
        } else {
            id = "";
        }
        strBuffer.append(ret + id + "{\n");
        for (int i = 0; i < members.length; ++i) {
            strBuffer.append("\t");
            if (includedId) {
                strBuffer.append(members[i].id + " : ");
            }
            strBuffer.append(CDR.printAny(members[i].value, includedId));
            if (i >= members.length - 1) continue;
            strBuffer.append(" , \n");
        }
        strBuffer.append("\n}");
        return strBuffer.toString();
    }

    private static String printSequence(Any a, String ret, boolean includedId) throws Exception {
        String id;
        StringBuffer str = new StringBuffer();
        DynSequence dynseq = (DynSequence)factory.create_dyn_any(a);
        Any[] contents = dynseq.get_elements();
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Sequence: ";
            }
        } else {
            id = "";
        }
        str.append(ret + id + "Sequence of length: " + contents.length + " ( \n");
        for (int i = 0; i < contents.length; ++i) {
            str.append("\t");
            str.append(CDR.printAny(contents[i], includedId));
            if (i >= contents.length - 1) continue;
            str.append(" ; \n");
        }
        str.append(" \n) ");
        return str.toString();
    }

    private static String printArray(Any a, String ret, boolean includedId) throws Exception {
        String id;
        StringBuffer str = new StringBuffer();
        DynArray dynarray = (DynArray)factory.create_dyn_any(a);
        Any[] arrayContents = dynarray.get_elements();
        try {
            id = a.type().id();
        }
        catch (Exception e) {
            id = "Array";
        }
        str.append(ret + id + " ( \n");
        for (int i = 0; i < arrayContents.length; ++i) {
            str.append("\t");
            str.append(CDR.printAny(arrayContents[i], includedId));
            if (i >= arrayContents.length - 1) continue;
            str.append(" ; \n");
        }
        str.append(" \n) ");
        return str.toString();
    }

    private static String printLonglong(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "LongLong: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_longlong();
    }

    private static String printUlonglong(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "ULongLong: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_ulonglong();
    }

    private static String printLongdouble(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "LongDouble: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_double();
    }

    private static String printWchar(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "WChar: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_wchar();
    }

    private static String printWstring(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "WString: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_wstring();
    }

    private static String printFixed(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Fixed: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.create_input_stream().read_fixed();
    }

    private static String printValue(Any a, String ret, boolean includedId) {
        String id;
        if (includedId) {
            try {
                id = a.type().id() + ": ";
            }
            catch (Exception e) {
                id = "Value: ";
            }
        } else {
            id = "";
        }
        return ret + id + a.extract_Value();
    }

    static {
        try {
            System.setProperty("org.omg.CORBA.ORBClass", "org.openorb.CORBA.ORB");
            System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.openorb.CORBA.ORBSingleton");
            orb = ORB.init();
            factory = new DynAnyFactoryImpl(orb);
        }
        catch (Exception e) {
            log.error((java.lang.Object)"", (Throwable)e);
            System.exit(-1);
        }
    }
}

