/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.bean;

import com.swimap.base.framework.ElementType;
import java.lang.reflect.Method;

class PropertyInfo {
    static final Object[] NO_PARA = new Object[0];
    private Method getMethod;
    private Method setMethod;

    PropertyInfo(Method getMethod, Method setMethod) {
        this.getMethod = getMethod;
        this.setMethod = setMethod;
    }

    final void setSetter(Method setMethod) {
        this.setMethod = setMethod;
    }

    final void setGetter(Method getMethod) {
        this.getMethod = getMethod;
    }

    final Object getValue(Object bean) {
        try {
            if (this.getMethod == null) {
                return null;
            }
            return this.getMethod.invoke(bean, NO_PARA);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    final Class<?> getValueType() {
        if (this.getMethod != null) {
            return this.getMethod.getReturnType();
        }
        if (this.setMethod != null) {
            return this.setMethod.getParameterTypes()[0];
        }
        return Object.class;
    }

    final void setValue(Object bean, Object value) {
        try {
            if (this.setMethod == null) {
                return;
            }
            this.setMethod.invoke(bean, value);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    final Class<?> getElementType() {
        if (this.setMethod == null) {
            return null;
        }
        ElementType type = this.setMethod.getAnnotation(ElementType.class);
        if (type == null) {
            return null;
        }
        return type.value();
    }
}

