/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.bean;

import com.swimap.base.rpc.bean.PropertyInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class BeanInfo {
    private Map<String, PropertyInfo> propertyMap;
    private List<String> readableProperties;
    private List<String> writableProperties;

    BeanInfo(Class beanClass) {
        Method[] methods = beanClass.getMethods();
        int capacity = methods.length / 2;
        this.propertyMap = new ConcurrentHashMap<String, PropertyInfo>(capacity);
        this.readableProperties = new ArrayList<String>(capacity);
        this.writableProperties = new ArrayList<String>(capacity);
        for (Method method : methods) {
            String name = method.getName();
            if ("getClass".equals(name)) continue;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                this.addGetProprety(this.getPropertyName(name, 3), method);
                continue;
            }
            if (name.startsWith("is") && name.length() > 2 && method.getParameterTypes().length == 0) {
                this.addGetProprety(this.getPropertyName(name, 2), method);
                continue;
            }
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            this.addSetProprety(this.getPropertyName(name, 3), method);
        }
    }

    private void addGetProprety(String name, Method getMethod) {
        PropertyInfo property = this.propertyMap.get(name);
        if (property != null) {
            property.setGetter(getMethod);
        } else {
            this.propertyMap.put(name, new PropertyInfo(getMethod, null));
        }
        this.readableProperties.add(name);
    }

    private void addSetProprety(String name, Method setMethod) {
        PropertyInfo property = this.propertyMap.get(name);
        if (property != null) {
            property.setSetter(setMethod);
        } else {
            this.propertyMap.put(name, new PropertyInfo(null, setMethod));
        }
        this.writableProperties.add(name);
    }

    private String getPropertyName(String methodName, int start) {
        String name = methodName.substring(start);
        return name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
    }

    final Object getProperty(Object bean, String name) {
        PropertyInfo p = this.propertyMap.get(name);
        if (p == null) {
            return p;
        }
        return p.getValue(bean);
    }

    final void setProperty(Object bean, String name, Object value) {
        PropertyInfo p = this.propertyMap.get(name);
        if (p != null) {
            p.setValue(bean, value);
        }
    }

    final Class<?> getPropertyType(String name) {
        PropertyInfo p = this.propertyMap.get(name);
        if (p != null) {
            return p.getValueType();
        }
        return Object.class;
    }

    final List<String> getReadablePropertyNames() {
        return this.readableProperties;
    }

    final List<String> getWritablePropertyNames() {
        return this.writableProperties;
    }

    final Class<?> getElementType(String name) {
        PropertyInfo p = this.propertyMap.get(name);
        if (p != null) {
            return p.getElementType();
        }
        return null;
    }
}

