/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc.bean;

import com.swimap.base.rpc.bean.BeanInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BeanHelper {
    private static final Map<Class<?>, BeanInfo> beanInfoCache = new ConcurrentHashMap();

    private static BeanInfo getBeanInfo(Class<?> cls) {
        BeanInfo info = beanInfoCache.get(cls);
        if (info == null) {
            info = new BeanInfo(cls);
            beanInfoCache.put(cls, info);
        }
        return info;
    }

    public static final Object getProperty(Object bean, String name) {
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        return BeanHelper.getBeanInfo(bean.getClass()).getProperty(bean, name);
    }

    public static final void setProperty(Object bean, String name, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(name, value);
        } else {
            BeanHelper.getBeanInfo(bean.getClass()).setProperty(bean, name, value);
        }
    }

    public static final Class<?> getPropertyType(Object bean, String name) {
        if (bean instanceof Map) {
            return Object.class;
        }
        return BeanHelper.getBeanInfo(bean.getClass()).getPropertyType(name);
    }

    public static final Class<?> getElementType(Object bean, String name) {
        return BeanHelper.getBeanInfo(bean.getClass()).getElementType(name);
    }

    public static final List<String> getReadablePropertyNames(Object bean) {
        if (bean instanceof Map) {
            return BeanHelper.getMapKeys((Map)bean);
        }
        return BeanHelper.getBeanInfo(bean.getClass()).getReadablePropertyNames();
    }

    public static final List<String> getWritablePropertyNames(Object bean) {
        if (bean instanceof Map) {
            return BeanHelper.getMapKeys((Map)bean);
        }
        return BeanHelper.getBeanInfo(bean.getClass()).getWritablePropertyNames();
    }

    public static final <T> T createBean(Class<T> beanClass) {
        try {
            return beanClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> getMapKeys(Map map) {
        Set keySet = map.keySet();
        ArrayList<String> result = new ArrayList<String>(keySet.size());
        for (Object key : keySet) {
            result.add(key.toString());
        }
        return result;
    }
}

