/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.DataTableHandler;
import com.swimap.base.rpc.MessageHandler;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcParameter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHelper {
    private static Log log = LogFactory.getLog(XmlHelper.class);
    private static final String UTF8 = "UTF-8";
    private static final String NONE = "";
    private static final String TAG_TABLE = "class";
    private static final String TAG_RECORD = "object";
    private static SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static ThreadLocal<TransformerHandler> transHandler = new ThreadLocal();
    private static SAXParserFactory parserFactory = XmlHelper.getParserFactory();
    private static ThreadLocal<SAXParser> parser = new ThreadLocal();

    private static SAXParserFactory getParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception e) {
            log.error((Object)NONE, (Throwable)e);
        }
        return factory;
    }

    public static TransformerHandler getTransformerHandler(OutputStream out) throws Exception {
        TransformerHandler handler = transHandler.get();
        if (handler == null) {
            handler = tf.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", UTF8);
            serializer.setOutputProperty("indent", "yes");
            transHandler.set(handler);
        }
        handler.setResult(new StreamResult(out));
        return handler;
    }

    static SAXParser getParser() throws Exception {
        SAXParser p = parser.get();
        if (p == null) {
            p = parserFactory.newSAXParser();
            parser.set(p);
        }
        return p;
    }

    public static void writeMessage(OutputStream out, RpcMessage message, String xsltURL) throws Exception {
        TransformerHandler hd = XmlHelper.getTransformerHandler(out);
        XmlHelper.writeRpcMessage(hd, message, xsltURL);
    }

    static void addAttribute(AttributesImpl atts, String name, String value) {
        if (name != null) {
            if (value != null) {
                atts.addAttribute(NONE, NONE, name, NONE, value);
            } else {
                atts.addAttribute(NONE, NONE, name, NONE, NONE);
            }
        }
    }

    public static void writeDataRecord(TransformerHandler hd, DataRecord record) throws SAXException {
        DataTable table = record.getOwner();
        AttributesImpl atts = new AttributesImpl();
        int i = 0;
        String name = null;
        for (String value : record.getValues()) {
            name = table.getColumnName(i++);
            XmlHelper.addAttribute(atts, name, value);
        }
        hd.startElement(NONE, NONE, TAG_RECORD, atts);
        if (record.hasTable()) {
            Collection<DataTable> nestedTables = record.getTables().values();
            for (DataTable nestedTable : nestedTables) {
                XmlHelper.writeDataTable(hd, nestedTable);
            }
        }
        hd.endElement(NONE, NONE, TAG_RECORD);
    }

    public static void writeDataTable(TransformerHandler hd, DataTable table) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XmlHelper.addAttribute(atts, "name", table.getName());
        if (table.hasParameter()) {
            Collection<RpcParameter> paras = table.getParameters();
            for (RpcParameter para : paras) {
                XmlHelper.addAttribute(atts, para.getName(), para.getValue());
            }
        }
        hd.startElement(NONE, NONE, TAG_TABLE, atts);
        for (DataRecord record : table) {
            XmlHelper.writeDataRecord(hd, record);
        }
        hd.endElement(NONE, NONE, TAG_TABLE);
    }

    static void writeRpcMessage(TransformerHandler hd, RpcMessage message, String xsltURL) throws Exception {
        hd.startDocument();
        if (xsltURL != null) {
            String info = "type=\"text/xsl\" href=\"" + xsltURL + "\"";
            hd.processingInstruction("xml-stylesheet", info);
        }
        AttributesImpl atts = new AttributesImpl();
        if (message.hasMessageId()) {
            XmlHelper.addAttribute(atts, "_mid", String.valueOf(message.getMessageId()));
        }
        if (message.hasSessionId()) {
            XmlHelper.addAttribute(atts, "_sid", message.getSessionId());
        }
        Collection<RpcParameter> paras = message.getParameters();
        for (RpcParameter para : paras) {
            XmlHelper.addAttribute(atts, para.getName(), para.getValue());
        }
        hd.startElement(NONE, NONE, message.getType(), atts);
        for (DataTable table : message.tables()) {
            XmlHelper.writeDataTable(hd, table);
        }
        hd.endElement(NONE, NONE, message.getType());
        hd.endDocument();
    }

    static RpcMessage parseMessage(InputStream is) {
        MessageHandler handler = new MessageHandler();
        try {
            XmlHelper.getParser().parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            log.error((Object)NONE, (Throwable)e);
        }
        return handler.getMessage();
    }

    public static DataTable parseDataTable(InputStream is) throws Exception {
        DataTableHandler handler = new DataTableHandler();
        try {
            XmlHelper.getParser().parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            log.error((Object)NONE, (Throwable)e);
        }
        return handler.getTable();
    }

    public static RpcMessage parseMessage(String xml, String charset) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes(charset));
        MessageHandler handler = new MessageHandler();
        XmlHelper.getParser().parse((InputStream)input, (DefaultHandler)handler);
        return handler.getMessage();
    }
}

