/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.WebConnector;
import com.swimap.base.rpc.nio.IConnector;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class WebConnectorSsl
extends SslSelectChannelConnector
implements IConnector {
    private static Log log = LogFactory.getLog(WebConnector.class);
    private boolean isRestricted;

    WebConnectorSsl(String host, int port, boolean isRestricted, SslContextFactory mySslContextFactory) throws Exception {
        super(mySslContextFactory);
        this.isRestricted = isRestricted;
        this.setHost(host);
        this.setPort(port);
        this.setResponseBufferSize(16384);
        this.setAcceptors(1);
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
        try {
            socket.setSendBufferSize(32768);
            socket.setReceiveBufferSize(32768);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public boolean isRestricted() {
        return this.isRestricted;
    }

    @Override
    public URI getURI() throws Exception {
        String host = this.getHost();
        return new URI("https", null, host, this.getPort(), "/api", null, null);
    }
}

