/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.nio.IConnector;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class WebConnector
extends SelectChannelConnector
implements IConnector {
    public static final int MAX_CHUNK_SIZE = 16384;
    public static final int BUFFER_SIZE = 32768;
    private static Log log = LogFactory.getLog(WebConnector.class);
    private boolean isRestricted;

    WebConnector(String host, int port, boolean isRestricted) throws Exception {
        this.isRestricted = isRestricted;
        this.setHost(host);
        this.setPort(port);
        this.setResponseBufferSize(16384);
        this.setAcceptors(1);
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
        try {
            socket.setSendBufferSize(32768);
            socket.setReceiveBufferSize(32768);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public boolean isRestricted() {
        return this.isRestricted;
    }

    @Override
    public URI getURI() throws Exception {
        String host = this.getHost();
        return new URI("http", null, host, this.getPort(), "/api", null, null);
    }
}

