/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.Base64;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ValueConvertor {
    public static final String FALSE_VALUE = "0";
    public static final String TRUE_VALUE = "1";
    private static final String INT_SEPARATOR = ",";
    private static final String STRING_SEPARATOR_NEW = " \r ";
    private static final String STRING_SEPARATOR_OLD = "\r";
    private static final String STRING_SEPARATOR_OLD_CONVERT = "\r\r";
    private static final String NULL_VALUE = "";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal();
    private static final Set<Class<?>> supportedType = new HashSet();

    private static DateFormat getDateFormat() {
        DateFormat format = dateFormat.get();
        if (format == null) {
            format = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.set(format);
        }
        return format;
    }

    static String formatDate(Date date) {
        return ValueConvertor.getDateFormat().format(date);
    }

    public static Date parseDate(String dateString) throws ParseException {
        return ValueConvertor.getDateFormat().parse(dateString);
    }

    public static Object convert(Object value, Class type) {
        if (type == String.class) {
            return value;
        }
        if (type == char[].class) {
            return ((String)value).toCharArray();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(value.toString());
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return value.equals(TRUE_VALUE);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(value.toString());
        }
        if (type == Date.class) {
            try {
                return ValueConvertor.parseDate(value.toString());
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (type == String[].class) {
            return ValueConvertor.getStringArray((String)value);
        }
        if (type == int[].class) {
            return ValueConvertor.getIntArray((String)value);
        }
        if (type == byte[].class) {
            return ValueConvertor.getByteArray((String)value);
        }
        return value;
    }

    public static int[] getIntArray(String value) {
        if (value == null || value.length() == 0) {
            return new int[0];
        }
        String[] ints = value.split(INT_SEPARATOR);
        int[] intArray = new int[ints.length];
        for (int n = 0; n < intArray.length; ++n) {
            intArray[n] = Integer.valueOf(ints[n]);
        }
        return intArray;
    }

    public static String[] getStringArray(String value) {
        if (ValueConvertor.useNewStringArrayConvert(value)) {
            return ValueConvertor.getStringArrayNew(value);
        }
        return ValueConvertor.getStringArrayOld(value);
    }

    private static String[] getStringArrayNew(String value) {
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        String[] arrays = value.split(STRING_SEPARATOR_NEW, -1);
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = arrays[i].replace(STRING_SEPARATOR_OLD_CONVERT, STRING_SEPARATOR_OLD);
        }
        return arrays;
    }

    public static String[] getStringArrayOld(String value) {
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        String sub = value.substring(0, value.length() - 1);
        return sub.split(STRING_SEPARATOR_OLD, -1);
    }

    public static byte[] getByteArray(String value) {
        if (value == null) {
            return null;
        }
        return Base64.decode(value);
    }

    public static char[] getCharArray(String value) {
        if (value == null || value.length() == 0) {
            return new char[0];
        }
        return value.toCharArray();
    }

    private static boolean useNewStringArrayConvert(String[] stringArray) {
        for (String str : stringArray) {
            if (str == null || str.indexOf(STRING_SEPARATOR_OLD) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean useNewStringArrayConvert(String value) {
        return value != null && value.indexOf(STRING_SEPARATOR_NEW) >= 0;
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof char[]) {
            return String.copyValueOf((char[])value);
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Double) {
            return value.toString();
        }
        if (value instanceof Date) {
            return ValueConvertor.formatDate((Date)value);
        }
        if (value instanceof String[]) {
            String[] strs = (String[])value;
            if (ValueConvertor.useNewStringArrayConvert(strs)) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < strs.length; ++i) {
                    if (strs[i] != null) {
                        String str = strs[i].replace(STRING_SEPARATOR_OLD, STRING_SEPARATOR_OLD_CONVERT);
                        sb.append(str);
                    } else {
                        sb.append(NULL_VALUE);
                    }
                    sb.append(STRING_SEPARATOR_NEW);
                }
                sb.delete(sb.length() - STRING_SEPARATOR_NEW.length(), sb.length());
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            boolean needReHandle = false;
            for (int i = 0; i < strs.length; ++i) {
                sb.append(strs[i] == null ? NULL_VALUE : strs[i]);
                sb.append(STRING_SEPARATOR_OLD);
                if (needReHandle || strs[i] == null || strs[i].length() <= 0 || strs[i].charAt(0) != ' ') continue;
                needReHandle = true;
            }
            return !needReHandle ? sb.toString() : ValueConvertor.handleOldString(sb.toString());
        }
        if (value instanceof int[]) {
            int[] ints = (int[])value;
            StringBuilder sb = new StringBuilder();
            if (ints.length > 0) {
                sb.append(ints[0]);
            }
            for (int i = 1; i < ints.length; ++i) {
                sb.append(INT_SEPARATOR);
                sb.append(ints[i]);
            }
            return sb.toString();
        }
        if (value instanceof Integer[]) {
            Integer[] ints = (Integer[])value;
            StringBuilder sb = new StringBuilder();
            if (ints.length > 0) {
                sb.append(ints[0]);
            }
            for (int i = 1; i < ints.length; ++i) {
                sb.append(INT_SEPARATOR);
                sb.append(ints[i]);
            }
            return sb.toString();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? TRUE_VALUE : FALSE_VALUE;
        }
        if (value instanceof byte[]) {
            return Base64.encode((byte[])value);
        }
        return value.toString();
    }

    private static String handleOldString(String value) {
        if (ValueConvertor.useNewStringArrayConvert(value)) {
            return value.substring(0, value.length() - 1).replace(STRING_SEPARATOR_OLD, STRING_SEPARATOR_NEW);
        }
        return value;
    }

    public static final boolean isSupportedType(Class<?> type) {
        return supportedType.contains(type);
    }

    static {
        supportedType.add(String.class);
        supportedType.add(Integer.TYPE);
        supportedType.add(Integer.class);
        supportedType.add(Long.TYPE);
        supportedType.add(Long.class);
        supportedType.add(Boolean.TYPE);
        supportedType.add(Boolean.class);
        supportedType.add(Double.TYPE);
        supportedType.add(Double.class);
        supportedType.add(Date.class);
        supportedType.add(String[].class);
        supportedType.add(int[].class);
        supportedType.add(byte[].class);
    }
}

