/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.monitor.Kpi;
import com.swimap.base.framework.monitor.KpiManagement;
import com.swimap.base.rpc.NATUtilService;
import com.swimap.base.rpc.RpcEMHandler;
import com.swimap.base.rpc.RpcEventHandlerProxy;
import com.swimap.base.rpc.RpcEventManager;
import com.swimap.base.rpc.RpcEventReceiver;
import com.swimap.base.rpc.RpcNamingCache;
import com.swimap.base.rpc.RpcPendingRequest;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcServer;
import com.swimap.base.rpc.RpcSessionClientIDPairs;
import com.swimap.base.rpc.RpcSocketProtocolTCP;
import com.swimap.base.rpc.mdp.IMDPHandle;
import com.swimap.base.rpc.mdp.MDPPendingRequest;
import com.swimap.base.rpc.mdp.SocketProtocolMDP;
import com.swimap.base.rpc.mrb.MRBServiceManager;
import com.swimap.base.rpc.msg.IMSGListener;
import com.swimap.base.rpc.nio.Client;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.ISocketProtocol;
import com.swimap.base.rpc.nio.SocketClientConnector;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketServerConnector;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

class StartListener
implements ServiceListener,
FrameworkListener {
    private static Log log4j = LogFactory.getLog(StartListener.class);

    StartListener() {
    }

    public void serviceChanged(ServiceEvent event) {
        if (1 == event.getType()) {
            try {
                RpcRegister.add(NATUtilService.class);
                RpcServer.getInstance().finishStart();
                this.rigestKpis();
                RpcEvent rpcEvent = RpcEvent.create("local.event.framework.started");
                rpcEvent.send();
            }
            catch (Exception e) {
                log4j.error((Object)"finishing start RPC Server failed, System will exit", (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FrameInformationManager.printInfo();
                System.exit(-1);
            }
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (4 == event.getType()) {
            try {
                RpcServer.getInstance().finishStart();
            }
            catch (Exception e) {
                log4j.error((Object)"packages refreshed .");
            }
        }
    }

    public void rigestKpis() {
        KpiManagement kpimge = KpiManagement.getInstance();
        kpimge.registerKpi("DSF", new Kpi("TaskThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                return ThreadPoolManager.getInstance().getTaskThreadPool().getInformation();
            }

            @Override
            public String getDescription() {
                return "DS RPC request process thread pool";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("AcceptThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                return ThreadPoolManager.getInstance().getAcceptThreadPool().getInformation();
            }

            @Override
            public String getDescription() {
                return "RPC accept pool";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("AssistPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                return ThreadPoolManager.getInstance().getAssistPool().getInformation();
            }

            @Override
            public String getDescription() {
                return "Process RPC task dispatch failed";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EventThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getEventThreadPool();
                return ThreadPoolManager.getInstance().getPoolInformation(threadPool);
            }

            @Override
            public String getDescription() {
                return "Process EM event and lock rpc event";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EventThreadPool"){

            @Override
            public String getKpiValue() {
                ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getMrbReadSingleThreadPool();
                return ThreadPoolManager.getInstance().getPoolInformation(threadPool);
            }

            @Override
            public String getDescription() {
                return "Process data from MRB";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MrbServerTaskThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                return ThreadPoolManager.getInstance().getMrbServerTaskThreadPool().getInformation();
            }

            @Override
            public String getDescription() {
                return "Process MRB request";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MSGTaskThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                return ThreadPoolManager.getInstance().getMSGTaskThreadPool().getInformation();
            }

            @Override
            public String getDescription() {
                return "Process ASN request";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("ReadThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getReadThreadPool();
                return ThreadPoolManager.getInstance().getPoolInformation(threadPool);
            }

            @Override
            public String getDescription() {
                return "Read data from clients, MRB, EM and so on.";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("ServerPushThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getServerPushThreadPool();
                return ThreadPoolManager.getInstance().getPoolInformation(threadPool);
            }

            @Override
            public String getDescription() {
                return "Client process serverpush event.";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("ReadEventThreadPool", "TYPE_NUMBER_PARES"){

            @Override
            public String getKpiValue() {
                ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getSingleThreadPool();
                return ThreadPoolManager.getInstance().getPoolInformation(threadPool);
            }

            @Override
            public String getDescription() {
                return "Dispatch EM data to EventThreadPool.";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EM_Listeners"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                int count = 0;
                Map<EventClassType, Set<String>> subscribers = RpcEMHandler.instance.GetSubscribers();
                for (Map.Entry<EventClassType, Set<String>> entry : subscribers.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    for (String sub : entry.getValue()) {
                        buffer.append(sub + ";");
                        ++count;
                    }
                    buffer.append("|");
                }
                buffer.append("total subscribers: " + count);
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "EM listners list.";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EM_Parsers"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Map<String, RpcEvent.IEventParser> subscribers = RpcEMHandler.instance.getParserMap();
                if (subscribers.size() == 0) {
                    buffer.append(0);
                    return buffer.toString();
                }
                for (Map.Entry<String, RpcEvent.IEventParser> entry : subscribers.entrySet()) {
                    buffer.append(entry.getKey()).append(";");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "EM parsers.";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EventHanleProxy"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                RpcEventHandlerProxy[] proxys = RpcEventReceiver.instance.getEventHandlers().values().toArray(new RpcEventHandlerProxy[0]);
                if (proxys == null || proxys.length == 0) {
                    buffer.append(0);
                    return buffer.toString();
                }
                for (int i = 0; i < proxys.length; ++i) {
                    buffer.append(proxys[i].getHandlerName()).append("=");
                    if (null != proxys[i].getEvenList()) {
                        buffer.append(proxys[i].getEvenList().size());
                    } else {
                        buffer.append(0);
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "EventHanle event list size";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EM_PendingSubscribers"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                List<RpcEventManager.PendingSubcription> pendingSubcription = RpcEventManager.instance().getPendingSubcription();
                if (pendingSubcription == null || pendingSubcription.size() == 0) {
                    buffer.append(0);
                    return buffer.toString();
                }
                for (int i = 0; i < pendingSubcription.size(); ++i) {
                    buffer.append(pendingSubcription.get(i).toString());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "EM Pending Subscribers which subscribe failed";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("EvenHandler"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Map<String, RpcEventHandlerProxy> handlers = RpcEventReceiver.instance.getEventHandlers();
                for (Map.Entry<String, RpcEventHandlerProxy> entry : handlers.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    buffer.append(entry.getValue().getEvenList().size());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "EventHanler and event list size";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("LocalSubscriber"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Map<EventClassType, Set<String>> localSubscriber = RpcEventReceiver.instance.getLocalSubscriber();
                for (Map.Entry<EventClassType, Set<String>> entry : localSubscriber.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    String[] listners = entry.getValue().toArray(new String[0]);
                    for (int i = 0; i < listners.length; ++i) {
                        buffer.append(listners[i]).append(';');
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "Local event type and listeners";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("RpcNamingCache"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Map<String, String> entrys = RpcNamingCache.instance.getNamingCache();
                for (Map.Entry<String, String> entry : entrys.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    buffer.append(entry.getValue());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "Rpc Naming cache content";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("TCP_PendingRequests"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Collection<SocketConnector> tcpConnections = RpcServer.getInstance().getConnectorManager().getSocketConnectors();
                for (SocketServerConnector socketServerConnector : tcpConnections) {
                    RpcSocketProtocolTCP protocolTcp = (RpcSocketProtocolTCP)socketServerConnector.getProtocol();
                    Map<Integer, RpcPendingRequest> entrys = protocolTcp.getRequsetPendings();
                    buffer.append(protocolTcp.toString()).append(":");
                    for (Map.Entry<Integer, RpcPendingRequest> entry : entrys.entrySet()) {
                        buffer.append(entry.getValue()).append(',');
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "TCP PendingRequests";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("TCP_ConnectionNum"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Collection<SocketConnector> tcpConnections = RpcServer.getInstance().getConnectorManager().getSocketConnectors();
                for (SocketServerConnector socketServerConnector : tcpConnections) {
                    RpcSocketProtocolTCP protocolTcp = (RpcSocketProtocolTCP)socketServerConnector.getProtocol();
                    Map<String, Integer> entrys = protocolTcp.getClientManeger();
                    buffer.append(protocolTcp.toString()).append(":");
                    for (Map.Entry<String, Integer> entry : entrys.entrySet()) {
                        buffer.append(entry.getKey()).append("=").append(entry.getValue()).append(',');
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "Connection number for one IP";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("Web_ContextMap"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Map<String, ServletContextHandler> context = RpcServer.getInstance().getContext();
                for (Map.Entry<String, ServletContextHandler> entry : context.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    buffer.append(entry.getValue().getContextPath());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "Connection number for one IP";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("Client_Serverpush"){

            @Override
            public String getKpiValue() {
                return RpcServerPush.getReceiver().toString();
            }

            @Override
            public String getDescription() {
                return "Client Serverpush handler";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("sessionid2clientid"){

            @Override
            public String getKpiValue() {
                Map<Integer, Long> pairs = RpcSessionClientIDPairs.pairs;
                StringBuilder buffer = new StringBuilder();
                for (Map.Entry<Integer, Long> entry : pairs.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    buffer.append(entry.getValue());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "sessionid to clientid";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MRB_Handlers"){

            @Override
            public String getKpiValue() {
                Map<Integer, IMDPHandle> hanles = MRBServiceManager.instance().getServiceHandlerMap();
                StringBuilder buffer = new StringBuilder();
                for (Map.Entry<Integer, IMDPHandle> entry : hanles.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    buffer.append(entry.getValue().getClass());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "MRB server handle list";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MSG_Handlers"){

            @Override
            public String getKpiValue() {
                Map<Integer, Set<IMSGListener>> hanles = MRBServiceManager.instance().getMsgListenerMap();
                StringBuilder buffer = new StringBuilder();
                for (Map.Entry<Integer, Set<IMSGListener>> entry : hanles.entrySet()) {
                    buffer.append(entry.getKey()).append("=");
                    Set<IMSGListener> items = entry.getValue();
                    for (IMSGListener imsgListener : items) {
                        buffer.append(imsgListener.getClass());
                        buffer.append(',');
                    }
                    buffer.append(entry.getValue().getClass());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "MSG server handle list";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MRB_Request_List"){

            @Override
            public String getKpiValue() {
                Collection<SocketConnector> connectors = RpcServer.getInstance().getConnectorManager().getSocketConnectors();
                StringBuilder buffer = new StringBuilder();
                for (SocketConnector socketConnector : connectors) {
                    ISocketProtocol protocol = socketConnector.getProtocol();
                    if (!(protocol instanceof SocketProtocolMDP)) continue;
                    SocketProtocolMDP mdpProtocol = (SocketProtocolMDP)protocol;
                    Map<Character, MDPPendingRequest> pendings = mdpProtocol.getRequsetPendings();
                    for (Map.Entry<Character, MDPPendingRequest> entry : pendings.entrySet()) {
                        buffer.append(entry.getKey()).append(",");
                    }
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "MDP current request list";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("MRB_Naming"){

            @Override
            public String getKpiValue() {
                Collection<SocketConnector> connectors = RpcServer.getInstance().getConnectorManager().getSocketConnectors();
                StringBuilder buffer = new StringBuilder();
                for (SocketConnector socketConnector : connectors) {
                    ISocketProtocol protocol = socketConnector.getProtocol();
                    if (!(protocol instanceof SocketProtocolMDP)) continue;
                    SocketProtocolMDP mdpProtocol = (SocketProtocolMDP)protocol;
                    Map<String, SocketProtocolMDP.MDPName> naming = mdpProtocol.getNaming();
                    for (Map.Entry<String, SocketProtocolMDP.MDPName> entry : naming.entrySet()) {
                        buffer.append(entry.getKey()).append("=");
                        buffer.append(entry.getValue()).append(";");
                    }
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "MRB service name and pid map";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("TCP_Connections"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                SocketConnection[] connections = Clients.getSocketConnections();
                for (int i = 0; i < connections.length; ++i) {
                    SocketConnection socketConnection = connections[i];
                    buffer.append(socketConnection.getClientID()).append('=');
                    buffer.append(socketConnection.getRemoteAddress()).append(':');
                    buffer.append(socketConnection.getRemotePort()).append('-');
                    buffer.append(socketConnection.getConnectionID()).append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "clientid=RemoteAddress:RemotePort-ConnectionID";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("TCP_clients"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Client[] clients = Clients.getClients();
                for (int i = 0; i < clients.length; ++i) {
                    Client client = clients[i];
                    buffer.append(client.getClientID()).append('-');
                    SocketConnection[] socketConnections = client.getConnections();
                    for (int j = 0; j < socketConnections.length; ++j) {
                        SocketConnection socketConnection = socketConnections[j];
                        buffer.append(socketConnection.getRemoteAddress()).append(':');
                        buffer.append(socketConnection.getRemotePort()).append(';');
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "TCP client information";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("WriteQueues"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                SocketClientConnector[] connectors = RpcServer.getInstance().getSocketServer().getClientConnectors();
                for (int i = 0; i < connectors.length; ++i) {
                    SocketClientConnector connector = connectors[i];
                    buffer.append(connector.getConnection().getRemoteAddress()).append(':');
                    buffer.append(connector.getConnection().getRemotePort()).append('=');
                    buffer.append(connector.getConnection().getWriteQueue().size());
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "WriteQueue information";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("Connection_information"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                Collection<SocketConnector> socketConnectors = RpcServer.getInstance().getConnectorManager().getSocketConnectors();
                for (SocketConnector socketConnector : socketConnectors) {
                    try {
                        buffer.append(socketConnector.getURI()).append('|');
                    }
                    catch (Exception e) {}
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "Connection information";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("SocketServer_pending"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                List<SocketConnector> socketConnectors = RpcServer.getInstance().getSocketServer().getPendingConnectors();
                for (SocketConnector socketConnector : socketConnectors) {
                    try {
                        buffer.append(socketConnector.getURI()).append('|');
                    }
                    catch (Exception e) {}
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "SocketServer pending information";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("client_connections"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                SocketClientConnector[] severConnectors = RpcServer.getInstance().getSocketServer().getClientConnectors();
                for (int i = 0; i < severConnectors.length; ++i) {
                    SocketConnection[] clientConnection = severConnectors[i].getConnections().toArray(new SocketConnection[0]);
                    buffer.append(severConnectors[i].toString());
                    for (int j = 0; j < clientConnection.length; ++j) {
                        SocketConnection socketConnection = clientConnection[j];
                        buffer.append(socketConnection.getSocketChannel().socket().getLocalAddress());
                    }
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "client connection information";
            }
        });
        kpimge.registerKpi("DSF", new Kpi("server_connections"){

            @Override
            public String getKpiValue() {
                StringBuilder buffer = new StringBuilder();
                List<SocketConnector> serverConnectors = RpcServer.getInstance().getSocketServer().getConnectors();
                for (SocketConnector socketConnector : serverConnectors) {
                    buffer.append(socketConnector.getHost()).append(':');
                    buffer.append(socketConnector.getPort()).append("; ");
                    buffer.append("|");
                }
                return buffer.toString();
            }

            @Override
            public String getDescription() {
                return "server connection information";
            }
        });
    }
}

