/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcEMHandler;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcUtil {
    private static Log log;
    public static final int DEFAULT_COMPRESS_LIMIT = 1024;
    static boolean enableCompress;
    public static int compressSize;
    private static final String MRB_READ_TIMEOUT = "imap.rpc.mrb.readtimeout";
    private static final long DEFAUT_MRB_READ_TIMEOUT = 300000L;
    private static final String EM_READ_TIMEOUT = "imap.rpc.em.readtimeout";
    private static final long DEFAUT_EM_READ_TIMEOUT = 300000L;
    private static final String ENABLE_ASSIST_POOL = "imap.assist.pool.enable";
    protected static int tcpClientsCount;
    private static final int RPCTimeoutDefault = 90000;
    private static int RPCTimeout;
    private static int ACCEPT_TIMEOUT;
    private static final int DEFAULT_MAX_CONNECTION = 10;
    private static final int MEMORY_STEP = 512;
    private static int NOTIFYBREAK_TIMEOUT;
    private static int compressThreshold;
    private static boolean needCompress;
    private static boolean isInitCompressThreshold;
    private static final String MEMORY_OLD_USED_PERCENT = "memory.old.used.percent";
    private static final int CACHE_MEMORY_PERCENT = 20;
    public static final int MAX_CONTENT_LEN;
    public static final int MAX_RECORD_SIZE;
    public static final int MAX_TOKEN_SIZE;
    public static final int MAX_ATTACH_SIZE;

    public static Map<EventClassType, Set<String>> getSubscribers() {
        ConcurrentHashMap<EventClassType, Set<String>> clone = new ConcurrentHashMap<EventClassType, Set<String>>();
        Map<EventClassType, Set<String>> subscribers = RpcEMHandler.instance.GetSubscribers();
        for (Map.Entry<EventClassType, Set<String>> entry : subscribers.entrySet()) {
            HashSet<String> subs = new HashSet<String>();
            for (String sub : entry.getValue()) {
                subs.add(sub);
            }
            clone.put(entry.getKey(), subs);
        }
        return clone;
    }

    public static long convertIp2Num(int index) {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            localhost = "127.0.0.1";
        }
        String[] strIp = localhost.split("\\.");
        Long[] ip = new Long[]{Long.parseLong(strIp[0]), Long.parseLong(strIp[1]), Long.parseLong(strIp[2]), Long.parseLong(strIp[3])};
        if (index == 3) {
            return (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String convertIp2Hex() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            localhost = "127.0.0.1";
        }
        String[] strIp = localhost.split("\\.");
        StringBuffer ip = new StringBuffer();
        for (int i = 0; i < strIp.length; ++i) {
            String seg = Integer.toHexString(Integer.parseInt(strIp[i]));
            if (seg.length() < 2) {
                seg = "0" + seg;
            }
            ip.append(seg);
        }
        return ip.toString().toUpperCase();
    }

    public static String getSystemTime() {
        SimpleDateFormat df = new SimpleDateFormat("MMddHHmmssSSS");
        String nowTime = df.format(System.currentTimeMillis());
        long tl = Long.parseLong(nowTime);
        return Long.toBinaryString(tl);
    }

    public static int getRPCTimeout() {
        if (RPCTimeout == -1) {
            RPCTimeout = 90000;
            try {
                String rpcTimeoutValue = System.getProperty("rpc.timeout");
                RPCTimeout = Integer.valueOf(rpcTimeoutValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return RPCTimeout;
    }

    public static int getAcceptTimeout() {
        if (ACCEPT_TIMEOUT == -1) {
            ACCEPT_TIMEOUT = 20000;
            try {
                String rpcTimeoutValue = System.getProperty("rpc.accept.timeout");
                ACCEPT_TIMEOUT = Integer.valueOf(rpcTimeoutValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ACCEPT_TIMEOUT;
    }

    public static int getNotifyBreakTimeout() {
        if (NOTIFYBREAK_TIMEOUT == -1) {
            NOTIFYBREAK_TIMEOUT = 600000;
            try {
                String rpcTimeoutValue = System.getProperty("rpc.notifybreak.timeout");
                NOTIFYBREAK_TIMEOUT = Integer.valueOf(rpcTimeoutValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NOTIFYBREAK_TIMEOUT;
    }

    private static int getMaxClientCountByMaxMemory(int maxMemory) {
        if (maxMemory < 640) {
            return 10;
        }
        if (640 <= maxMemory && maxMemory < 1024) {
            return 25;
        }
        if (1024 <= maxMemory && maxMemory < 1300) {
            return 60;
        }
        if (1300 <= maxMemory && maxMemory < 2048) {
            return 80;
        }
        return 100;
    }

    public static int getMaxClientCount() {
        try {
            String maxClientCount = System.getProperty("imap.rpc.maxClientCount");
            if (maxClientCount != null) {
                return Integer.valueOf(maxClientCount);
            }
            int maxMemory = RpcUtil.getMaxMemory();
            int clientN = RpcUtil.getMaxClientCountByMaxMemory(maxMemory);
            log.warn((Object)("maxMemory:" + maxMemory + ",clientN=" + clientN));
            return clientN;
        }
        catch (Exception e) {
            return 10;
        }
    }

    private static int getMaxMemory() {
        try {
            RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = RuntimemxBean.getInputArguments();
            for (String arg : arguments) {
                if (!arg.startsWith("-Xmx") || !arg.endsWith("m")) continue;
                return Integer.valueOf(arg.substring(4, arg.length() - 1));
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return 512;
    }

    public static Set<String> getLocalIPAddressSet() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            return new HashSet<String>(0);
        }
        HashSet<String> hosts = new HashSet<String>();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> cardipaddress = ni.getInetAddresses();
            while (cardipaddress.hasMoreElements()) {
                InetAddress inetAddress = cardipaddress.nextElement();
                if (!inetAddress.isSiteLocalAddress()) continue;
                hosts.add(inetAddress.getHostAddress());
            }
        }
        return hosts;
    }

    public static String[] getAvailableIP() {
        String ips = System.getProperty("imap.rpc.availableIP");
        String[] availableIP = new String[]{};
        if (ips != null) {
            availableIP = ips.split(";");
        }
        return availableIP;
    }

    public static void initCompressThreshold() {
        if (!isInitCompressThreshold) {
            isInitCompressThreshold = true;
            String value = System.getProperty("CompressThreshold");
            try {
                if (value != null) {
                    compressThreshold = Integer.valueOf(value) * 1024;
                    needCompress = true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public static boolean isNeedCompress() {
        RpcUtil.initCompressThreshold();
        return needCompress;
    }

    public static int getCompressThreshold() {
        RpcUtil.initCompressThreshold();
        return compressThreshold;
    }

    public static long getMRBReadTimeOut() {
        return Long.getLong(MRB_READ_TIMEOUT, 300000L);
    }

    public static long getEMReadTimeOut() {
        return Long.getLong(EM_READ_TIMEOUT, 300000L);
    }

    public static boolean enableAssistPool() {
        String enableAssistPool = System.getProperty(ENABLE_ASSIST_POOL);
        if (enableAssistPool != null) {
            return Boolean.getBoolean(ENABLE_ASSIST_POOL);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkQueue(Collection queue, int highMemorySize, int lowMemorySize) {
        Collection collection = queue;
        synchronized (collection) {
            int currentSize;
            Long memoryUsedPercent = Long.getLong(MEMORY_OLD_USED_PERCENT);
            if (memoryUsedPercent == null) {
                return true;
            }
            boolean isMemoryNotEnough = memoryUsedPercent != null && 100L - memoryUsedPercent < 20L;
            int maxCacheSize = isMemoryNotEnough ? lowMemorySize : highMemorySize;
            if (maxCacheSize < (currentSize = queue.size())) {
                log.error((Object)String.format("checkQueue: ABNORMAL!!!, memoryUsedPercent=%s, cacheSize=%s currentSize=%s ", memoryUsedPercent, maxCacheSize, currentSize));
                return false;
            }
            return true;
        }
    }

    static {
        String compressSizeString;
        log = LogFactory.getLog(RpcUtil.class);
        enableCompress = false;
        compressSize = 1024;
        String enableCommpressString = System.getProperty("low.bandwidth.env");
        if (enableCommpressString != null) {
            boolean bl = enableCompress = !enableCommpressString.toLowerCase().equals("false");
        }
        if ((compressSizeString = System.getProperty("rpc.compress.size")) != null) {
            try {
                compressSize = Integer.getInteger(compressSizeString);
            }
            catch (Exception e) {
                compressSize = 1024;
            }
        }
        tcpClientsCount = 0;
        RPCTimeout = -1;
        ACCEPT_TIMEOUT = -1;
        NOTIFYBREAK_TIMEOUT = -1;
        compressThreshold = 2048;
        needCompress = false;
        isInitCompressThreshold = false;
        MAX_CONTENT_LEN = Integer.getInteger("imap.rpc.maxContentLen", 0x6400000);
        MAX_RECORD_SIZE = Integer.getInteger("imap.rpc.maxRecordSize", 0x1400000);
        MAX_TOKEN_SIZE = Integer.getInteger("imap.rpc.maxTokenSize", 0x1400000);
        MAX_ATTACH_SIZE = Integer.getInteger("imap.rpc.maxAttachSize", 0x3200000);
    }
}

